/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.prefs;

import xnap.XNap;
import xnap.gui.*;
import xnap.gui.util.GUIHelper;
import xnap.gui.text.EmacsKeyBindings;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

public class PersonalPrefsPanel extends AbstractPreferencesPanel {
    
    //--- Data field(s) ---

    private ValidatedTextField jteUsername;
    private ValidatedTextField jtePassword;
    private ValidatedTextField jteEmail;
    private JComboBox jcbLanguage;

    private JCheckBox jcAutoVersionCheck;
    private JCheckBox jcEmacsKeyBindings;
    private JCheckBox jcbAutoCompletion;


    //--- Constructor(s) ---

    public PersonalPrefsPanel()
    {
	setLayout(new GridBagLayout());

        GridBagHelper.addLabel(this, XNap.tr("Username"));
        jteUsername = new ValidatedTextField
	    (prefs.getUsername(), 20, ValidatedTextField.EMAIL);
        GridBagHelper.add(this, jteUsername);
	
        GridBagHelper.addLabel(this, XNap.tr("Password"));
        jtePassword = new ValidatedTextField
	    (prefs.getPassword(), 20, ValidatedTextField.EMAIL);
        GridBagHelper.add(this, jtePassword);

        GridBagHelper.addLabel(this, XNap.tr("Email"));

	/* this is just a crude approach, to only allow valid email addresses
	   someone would have to read RFC 2821 and RFC 2822.  */
        jteEmail = new ValidatedTextField
	    (prefs.getEmail(), 20, ValidatedTextField.EMAIL);
	GridBagHelper.add(this, jteEmail);

	GridBagHelper.addLabel(this, XNap.tr("Language"));
	jcbLanguage = new JComboBox();
	jcbLanguage.setRenderer(new LocaleCellRenderer());
	jcbLanguage.addItem(new Locale("", "", ""));
	for (int i = 0; i < XNap.LANGUAGES.length; i++) {
	    jcbLanguage.addItem(XNap.LANGUAGES[i]);
	    if (prefs.getLanguage().equals(XNap.LANGUAGES[i].getLanguage())) {
		// we have already added the "system default" locale
		jcbLanguage.setSelectedIndex(i + 1);
	    }
	}
	GridBagHelper.add(this, jcbLanguage, false);

	JPanel jpMisc = new JPanel(new GridBagLayout());
	jpMisc.setBorder(new TitledBorder(XNap.tr("Miscellaneous", 1)));

	jcAutoVersionCheck = new JCheckBox(XNap.tr("Check for New Version", 1),
                                           prefs.getAutoVersionCheck());
	GridBagHelper.add(jpMisc, jcAutoVersionCheck);
	
	jcEmacsKeyBindings = 
	    new JCheckBox(XNap.tr("Use Emacs Keybindings", 1),
			  prefs.getUseEmacsKeyBindings());
	jcEmacsKeyBindings.setToolTipText(GUIHelper.tt(XNap.tr("Enables the essential Emacs keybindings to facilitate editing text.<br><small>(see FAQ for list of features)</small>")));
	GridBagHelper.add(jpMisc, jcEmacsKeyBindings);

	jcbAutoCompletion = new JCheckBox(XNap.tr("Auto Completion",1),
					  prefs.getAutoComplete());
	jcbAutoCompletion.setToolTipText(GUIHelper.tt(XNap.tr("Activate completion of user input for all search fields which have a <b>history</b>.")));
	GridBagHelper.add(jpMisc, jcbAutoCompletion);

	GridBagHelper.add(this, jpMisc);


	GridBagHelper.addVerticalSpacer(this);
    }

    public void apply() 
    {
	prefs.setUsername(jteUsername.getText());
	prefs.setPassword(jtePassword.getText());
	prefs.setEmail(jteEmail.getText());
	prefs.setLanguage(((Locale)jcbLanguage.getSelectedItem()).getLanguage());

	prefs.setAutoVersionCheck(jcAutoVersionCheck.isSelected());
	prefs.setUseEmacsKeyBindings(jcEmacsKeyBindings.isSelected());
	prefs.setAutoComplete(jcbAutoCompletion.isSelected());
    }

    public Icon getIcon()
    {
	return XNapFrame.getIcon("gohome.png");
    }

    public String getTitle()
    {
	return XNap.tr("Personal");
    }

    protected class LocaleCellRenderer extends DefaultListCellRenderer {

	public Component getListCellRendererComponent
	    (JList list, Object val, int idx, boolean isSel, boolean hasFocus) 
	{
	    super.getListCellRendererComponent
		(list, val, idx, isSel, hasFocus);

	    String s = ((Locale)val).getDisplayLanguage();
	    setText((s.length() > 0) ? s : XNap.tr("System Default"));

	    return this;
	}
    }

}



