/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.net;

import xnap.util.SearchFilter;

import java.io.IOException;
import java.util.LinkedList;

public abstract class AbstractBrowse implements IBrowse {

    //--- Constant(s) ---

    //--- Data field(s) ---

    protected LinkedList buffer = new LinkedList();
    protected boolean finished = false;
    protected IUser user;

    //--- Constructor(s) ---

    public AbstractBrowse(IUser user)
    {
	this.user = user;
    }

    // Method(s)
    
    public synchronized void add(ISearchResult sr)
    {
	buffer.add(sr);
    }

    public synchronized int available() throws IOException
    {
	return (buffer.size() == 0 && finished) ? -1 : buffer.size();
    }

    public IUser getUser()
    {
	return user;
    }

    public synchronized ISearchResult next() throws IOException
    {
	return (ISearchResult)buffer.removeFirst();
    }

    public String toString()
    {
	return user.getName();
    }

}
