/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.net;

import xnap.net.event.ChannelListener;

import java.io.IOException;

public interface IChannel {

    //--- Data field(s) ---

    long AWAY_MESSAGE_INTERVAL = 20 * 1000;

    //--- Method(s) ---

    /**
     * Add l.
     */
    void addChannelListener(ChannelListener l);

    /**
     * Returns true, if topic can be changed.
     */
    boolean canChangeTopic();

    /**
     * Sets the topic of this channel.
     */
    void changeTopic(String newTopic) throws IOException;
    
    /**
     * Closes this channel.
     */
    void close();

    /**
     * Returns the name of the channel.
     */
    String getName();

    /**
     * Returns a reference to the chat server.
     */
    IChatServer getServer();

    /**
     * Returns the topic of this channel.
     */
    String getTopic();

    /**
     * Returns the users talking on this channel.
     */
    IUser[] getUsers();

    /**
     * Returns the number of users talking on this channel.
     */
    int getUserCount();

    /**
     * Join channel.
     */
    void join() throws IOException;

    /**
     * Remove listener.
     */
    void removeChannelListener(ChannelListener l);

    /**
     * Sends a message to channel.
     */
    void sendMessage(String message) throws IOException;

}
