/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift.gui;

import java.awt.event.ActionEvent;
import java.util.Vector;

import javax.swing.*;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

import xnap.gui.AbstractPanel;
import xnap.gui.XNapFrame;
import xnap.gui.table.NumberCellRenderer;
import xnap.gui.table.SortableTableModel;
import xnap.gui.table.TableHeaderListener;
import xnap.net.event.StatusChangeEvent;
import xnap.net.event.StatusChangeListener;
import xnap.plugin.gift.gui.table.StatsTableModel;
import xnap.plugin.gift.net.Stats;
import xnap.plugin.gift.util.GiftPreferences;

public class StatsPanel extends AbstractPanel {

    //--- Constant(s) ---
    
    //--- Data field(s) ---

    private GiftPreferences giftPrefs = GiftPreferences.getInstance();

    private StatsTableModel dtm;
    private JTable jta;
    private JLabel jlStatus;

    UpdateAction updateAction = new UpdateAction();
    //--- Constructor(s) ---
    
    public StatsPanel()
    {
	initialize ();
    }
    
    //--- Method(s) ---

    public void initialize()
    {
	/* status */
	jlStatus = new JLabel("No information, yet");

	/* table */
	dtm = new StatsTableModel();
	SortableTableModel stm = new SortableTableModel(dtm);
	jta = new JTable(stm);
    
	jta.setShowGrid(false);
	TableHeaderListener.install(jta);

	JScrollPane jsp = new JScrollPane();
	jsp.setViewportView(jta);

	/* me */
	//setBorder(new EmptyBorder(5, 5, 5, 5));
	setLayout(new java.awt.BorderLayout());
	add(jlStatus, "North");
	add(jsp, "Center");

	alignColumns();
    }

    private void alignColumns()
    {
        DefaultTableCellRenderer r = new NumberCellRenderer();
        TableColumn column;

        column = jta.getColumn("Files");
        column.setPreferredWidth(100);
        column.setCellRenderer(r);
        column = jta.getColumn("Size");
        column.setPreferredWidth(100);
        column.setCellRenderer(r);
    	column = jta.getColumn("Users");
    	column.setPreferredWidth(100);
    	column.setCellRenderer(r);
    }
    

    public void setMyStatus(String newValue)
    {
	jlStatus.setText(newValue);
    }

    public AbstractAction[] getActions()
    {
	return (new AbstractAction[] {updateAction});
    }


    /**
     * 
     */
    private class UpdateAction extends AbstractAction 
	implements StatusChangeListener 
    {
	Stats stats;

        public UpdateAction() 
	{
            putValue(Action.NAME, "Update");
            putValue(Action.SHORT_DESCRIPTION,
		     "Update the statistics" );
	    putValue(Action.SMALL_ICON, XNapFrame.getIcon("reload.png"));
            putValue(Action.MNEMONIC_KEY, new Integer('U'));
        }

        public void actionPerformed(ActionEvent event) 
	{
	    final UpdateAction me = this;

	    (new Thread("GiftStats") 
		{
		    public void run() 
		    {
			stats = new Stats(giftPrefs.getGiftHost(), 
					  giftPrefs.getGiftPort());
			
			stats.addStatusChangeListener(me);
			stats.connect();

			if (stats.getStatus() == Stats.STATUS_CONNECTED)
			    {
				Vector v = stats.getResults();
				if (v != null) {
				    dtm.clear();

				    for (int i = 0; i < v.size(); i++)
					dtm.add((Object[])v.get(i));
				}
			    }

			stats.close();
			stats.removeStatusChangeListener(me);
			
		    }
		}).start();
	}

	public void statusChange(StatusChangeEvent e)
	{
	    setMyStatus(e.getMessage());
	}
    }
}
