/*
 * xnap
 *
 * ProtocolHelper.java
 * Created on 18.12.2002 by Tammo
 *
 * copyright (c) 2002 by Tammo van Lessen, University of Stuttgart.
 * All Rights Reserved.
 * 
 */
package xnap.plugin.gift.net;

import xnap.XNap;

/**
 * ProtocolHelper
 * 
 * @author <a href="mailto:tvanlessen@taval.de>Tammo van Lessen</a>
 * @version   CVS $Id: ProtocolHelper.java,v 1.1 2003/01/15 16:17:53 squig Exp $
 */
public class ProtocolHelper {

	public static final Object[] MEDIA_REALM = {
		"everything", "audio", "video", "images", "software", "documents" // text	
	};

	protected static byte[] attach() {
		return new String("ATTACH\n" +
			"     client(XNap)\n" +
			"     version("+XNap.VERSION+")\n" +
			"  ;\n").getBytes();
	}

	protected static byte[] detach() {
		return "DETACH;\n".getBytes();
	}

	// maybe add META stuff.
	protected static byte[] search(String sessionId, String query, String exclude, int realm) {
		return new String("SEARCH ("+sessionId+")\n" +
			"     query ("+query+")\n" +
			"     exclude ("+exclude+")\n" +
			"     realm ("+MEDIA_REALM[realm]+")\n" +
			"     protocol (giFT)\n" +
			"  ;\n").getBytes();
	}

	protected static byte[] getStats() {
		return "STATS;\n".getBytes();
	}
}
