/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift.net.event.listener;

import java.util.EventListener;

import xnap.plugin.gift.net.event.OfflineEvent;
import xnap.plugin.gift.net.event.OnlineEvent;
import xnap.plugin.gift.net.event.StatsEvent;


/**
 * NetworkEventListener;
 *
 * @author <a href="mailto:tvanlessen@taval.de">Tammo van Lessen</a>
 * @version CVS $Id: NetworkEventListener.java,v 1.1 2003/01/15 16:17:54 squig Exp $
 */
public interface NetworkEventListener extends EventListener {
    //~ Methods ----------------------------------------------------------------

    /**
     * Gets called if connection to giFT is lost
     *
     * @param evt online event
     */
    void attached(OnlineEvent evt);

    /**
     * Gets called if connection to giFT is established
     *
     * @param evt offline event
     */
    void detached(OfflineEvent evt);

    /**
     * Gets called on stats update
     *
     * @param evt stats event
     */
    void statsUpdate(StatsEvent evt);
}
