/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift.net.lexer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;


/**
 * StreamLexer
 * 
 * Parses GiFT-Commands
 *
 * @author <a href="mailto:tvanlessen@taval.de">Tammo van Lessen</a>
 * @version CVS $Id: StreamLexer.java,v 1.1 2003/01/15 16:17:54 squig Exp $
 */
public class StreamLexer {
    //~ Instance fields --------------------------------------------------------

    private BufferedReader reader;

    //~ Constructors -----------------------------------------------------------

    /**
     * Constructor for StreamLexer.
     *
     * @param in	the input stream
     */
    public StreamLexer(InputStream in) {
        reader = new BufferedReader(new InputStreamReader(in));
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * Main method, only for testing purposes.
     *
     * @param args	commandline args
     *
     * @throws IOException
     */
    public static void main(String[] args) throws IOException {
        Command command;
        StreamLexer lexer = new StreamLexer(System.in);
        while (!(command = lexer.parse()).getCommand().equals("QUIT")) {
                System.out.println(command.print());
        }
    }

    /**
     * Parses the Inputstream and returns the corresponding command
     * object. 
     * 
     * Blocks until a whole command is read from the stream.
     *
     * @return the parsed command object
     *
     * @throws IOException
     */
    public Command parse() throws IOException {
        Command cmd = new Command();
        cmd.parse(nextCommand());
        return cmd;
    }

    private String nextCommand() throws IOException {
        StringBuffer cmd = new StringBuffer();
        int cint;
		// read until command is complete!
        while ((cint = reader.read()) != ';') {
            char ch = (char) cint;
            cmd.append(ch);
        }
        return cmd.toString().trim() + ";";
    }
}
