/*
 * 08/25/2001
 *
 * GUID.java
 * Copyright (C) 2001 Frederik Zimmer
 * tristian@users.sourceforge.net
 * http://sourceforge.net/projects/ziga/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package xnap.plugin.gnutella.net;

import xnap.plugin.gnutella.util.*;

public class GUID
{
    
    protected static char[] hexDigits = {
	'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D',
	'E', 'F'
    };
    
    protected byte[] guid;
    protected int hashCode;
	
    public GUID() {
	guid = nextGUID();
	hashCode = computeHashCode();
    }
	
    public GUID(byte[] guid) {
	this.guid = guid;
	hashCode = computeHashCode();
    }
	
    public byte[] getBytes() {
	return guid;
    }
	
    /**
     * Get the next GUID.
     *
     * @return a GUID;
     */
    public static byte[] nextGUID() {
	UUID uuid = new UUID();
	byte[] guid = uuid.getUUID();
	guid[8] = (byte) 0xFF;
	guid[15] = (byte) 0x00;
	return guid;
    }
	
    public static GUID parseGUID(String s) {
	if (s.length() != 32) {
	    throw new NumberFormatException("GUID too short");
	}

	char[] uuidchars = s.toCharArray();
		
	byte[] uuid = new byte[16];
	for (int i = 0, j = 0; i < 16; i++, j++)  {
	    uuid[i] = (byte) (((Character.digit(uuidchars[j++], 16) << 4) & 
			       0xF0) | (Character.digit(uuidchars[j], 16) & 
					0x0F));
	} 
	
	return new GUID(uuid);
    }
	
    protected int computeHashCode() {
	long i;
	int j;

	i = (((long)(guid[7] & 0xFF) << 56) |
	     ((long)(guid[6] & 0xFF) << 48) |
	     ((long)(guid[5] & 0xFF) << 40) |
	     ((long)(guid[4] & 0xFF) << 32) |
	     ((long)(guid[3] & 0xFF) << 24) |
	     ((long)(guid[2] & 0xFF) << 16) |
	     ((long)(guid[1] & 0xFF) <<  8) |
	     ((long)(guid[0] & 0xFF)));
				
	j = (((int)(guid[12] & 0xFF) << 24) |
	     ((int)(guid[11] & 0xFF) << 16) |
	     ((int)(guid[10] & 0xFF) <<  8) |
	     ((int)(guid[9] & 0xFF)));
				
	return (int) ((i ^ (i >> 32)) ^ j);
    }
	
    public int hashCode() {
	return hashCode;
    }
	
    public String toString() {
	StringBuffer sb = new StringBuffer();
		
	for (int i = 0; i < guid.length; i++) {
	    sb.append(hexDigits[(guid[i] & 0xF0) >> 4]);
            sb.append(hexDigits[guid[i] & 0x0F]);
	}
		
	return sb.toString();
    }
	
    public boolean equals(Object obj) {
	if (obj == null) {
	    return false;
	}
	else {
	    GUID compareGuid;
	    try {
		compareGuid = (GUID) obj;
	    }
	    catch(ClassCastException e) {
		return false;
	    }
	    for (int i = 0; i < guid.length; i++) {
		if (guid[i] != compareGuid.guid[i]) {
		    return false;
		}
	    }
	    return true;
	}
    }

}
