/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.gui;

import xnap.*;
import xnap.gui.*;
import xnap.net.*;
import xnap.plugin.nap.net.*;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.server.*;
import xnap.plugin.nap.util.*;
import xnap.util.*;
import xnap.util.event.*;

import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.net.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.text.BadLocationException;

public class ConsolePanel extends AbstractPanel implements MessageListener {

    //--- Constant(s) ---
    
    private static final int MESSAGES[] = {
	MessageFactory.LOGIN_ERROR, MessageFactory.LOGIN_ATTEMPT, 
	MessageFactory.MOTD, MessageFactory.ERROR_MESSAGE
    };

    //--- Data field(s) ---

    private Preferences prefs = Preferences.getInstance();

    private ConsolePane cp;

    //--- Constructor(s) ---
    
    public ConsolePanel()
    {
	initialize();

	for (int i = 0; i < MESSAGES.length; i++) {
	    MessageHandler.subscribe(MESSAGES[i], this);
	}
    }

    //--- Method(s) ---

    public void initialize() 
    {
	cp = new ConsolePane();

	setLayout(new BorderLayout());
	add(cp, BorderLayout.CENTER);
    }

    public void append(String text) 
    {
	cp.appendLater(text);
    }

    public void messageReceived(ServerMessage msg)
    {
	append("* " + msg.getServer().getHost() + ": " + msg.toString() + "\n");
    }

    public void die()
    {
	for (int i = 0; i < MESSAGES.length; i++) {
	    MessageHandler.unsubscribe(MESSAGES[i], this);
	}
    }

    public AbstractAction[] getActions()
    {
	return (new AbstractAction[] { });
    }

}
