/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util;

import xnap.XNap;
import xnap.cmdl.*;
import xnap.net.*;
import xnap.net.event.*;

import java.beans.*;
import java.io.*;
import java.net.*;
import java.util.*;
import org.apache.log4j.Logger;

public class UploadQueue extends TransferQueue
    implements PropertyChangeListener {

    //--- Constant(s) ---

    //--- Data field(s) ---

    private static UploadQueue singleton = new UploadQueue();

    //--- Constructor(s) ---

    private UploadQueue()
    {
	super("UploadQueue");

	logger = Logger.getLogger(DownloadQueue.class);

	prefs.addPropertyChangeListener("limitUploads", this);
	prefs.addPropertyChangeListener("maxUploads", this);
	prefs.addPropertyChangeListener("limitUploadsPerUser", this);
	prefs.addPropertyChangeListener("maxUploadsPerUser", this);

	updateLimit();

	Executer.addCommand(new ListUlsCmd());
	Executer.addCommand(new AbortUlCmd());
    }

    //--- Method(s) ---

    public static UploadQueue getInstance()
    {
	return singleton;
    }

    public boolean add(IUpload u) 
    {
	return add(new SimpleUpload(u));
    }

    /**
     * Checks if there isn't already an equivalent upload before adding.
     */
    public boolean add(IUploadContainer u) 
    {
	// don't add upload if we already have the same
	if (!isQueued(u) && !isRunning(u)) {
	    logger.debug("add " + u);
	    super.add(u);
	    if (check(u)) {
		return enqueue(u, isPreferred(u));
	    }
	}

	return false;
    }

    public boolean canStart(ITransferContainer t)
    {
	if (prefs.getLimitUploadsPerUser()) {
	    IUser u = t.getUser();
	    if (u.getMaxUploads() == IUser.TRANSFER_DEFAULT) {
		return (u.getLocalUploadCount() 
			< prefs.getMaxUploadsPerUser());
	    }
	    else {
		return (u.getLocalUploadCount() < u.getMaxUploads());
	    }
	}
	return true;
    }

    public boolean check(IUploadContainer uc)
    {
	// FIX: also add leecher controls here
	if (uc.getUser().getMaxUploads() == IUser.TRANSFER_NEVER) {
	    uc.reject(XNap.tr("User blocked"));
	    return false;
	}

	return true;
    }

    public int getLocalQueuePos(IUpload u)
    {
	return super.getLocalQueuePos(new SimpleUpload(u));
    }

    /**
     * Returns true, if <code>uc</code> should be preferred over other
     * downloads in the queue.
     *
     * We grant one upload slot per download.
     */
    public boolean isPreferred(IUploadContainer uc)
    {
	return ((uc.getUser().getMaxUploads() == IUser.TRANSFER_UNLIMITED
		 && (!prefs.getLimitUploadsPerUser() 
		     || (uc.getUser().getLocalUploadCount() 
			 < prefs.getMaxUploadsPerUser())))
		|| (uc.getUser().getLocalDownloadCount() 
		    > uc.getUser().getLocalUploadCount()));
    }

    

    public boolean isRunning(IUpload u)
    {
	return super.isRunning(new SimpleUpload(u));
    }

    public void startUpload(IUploadContainer uc)
    {
	startTransfer(uc);
    }

    public void propertyChange(PropertyChangeEvent e)
    {
	updateLimit();
    }

    protected void updateLimit()
    {
	setMaxTransfers(prefs.getLimitUploads() ? prefs.getMaxUploads() : 0);
    }

    protected class ListUlsCmd extends AbstractCommand
    {
	public ListUlsCmd()
	{
	    putValue(CMD, new String[] {"listuploads", "lul", "pup"});
	    putValue(SHORT_HELP, "Shows the upload queue.");
	}
	
	public boolean execute(String[] parms)
	{
	    print();
	    return true;
	}
    }

    protected class AbortUlCmd extends AbstractCommand
    {
	public AbortUlCmd()
	{
	    putValue(CMD, new String[] { "abortupload", "aul" });
	    putValue(PARAMETER, "id");
	    putValue(SHORT_HELP, "Aborts an upload.");
	}
	
	public boolean execute(String[] argv)
	    throws SyntaxException, ParameterException
	{
	    if (lastTransfers == null) {
		lastTransfers = getTransfers();
	    }

	    int i = getInt(argv, 0, lastTransfers.length - 1);
	    abort(lastTransfers[i]);
	    
	    return true;
	}
    }

}
