/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util;

import xnap.XNap;
import xnap.XNapLoader;
import xnap.net.HttpConnection;

import java.io.*;
import java.net.*;
import java.util.*;
import org.apache.log4j.Logger;

public class VersionManager
{

    //--- Constant(s) ---

    //--- Data field(s) ---

    private static Logger logger = Logger.getLogger(VersionManager.class);
    private static Preferences prefs = Preferences.getInstance();

    private String info = "";
    private String currentVersion = "";
    private long currentReleaseNr = -1;

    //--- Constructor(s) ---

    public VersionManager()
    {
    }

    //--- Method(s) ---

    public boolean check() throws IOException
    {
	boolean showUpdate = false;
	
	prefs.setLastUpdateCheck(System.currentTimeMillis());
	prefs.write();
			
	HttpConnection conn = new HttpConnection();
	try {
	    conn.connect(prefs.getUpdateURL());
	    
	    String line = conn.nextLine();
	    if (line != null) {
		StringTokenizer t = new StringTokenizer(line, " ");
		
		if (t.hasMoreTokens()) {
		    currentVersion = t.nextToken();
		}

		if (t.hasMoreTokens()) {
		    try {
			currentReleaseNr = Long.parseLong(t.nextToken());
		    }
		    catch (NumberFormatException e) {
		    }
		}

		showUpdate = (currentReleaseNr > XNap.RELEASE_NR);
	    }
	    
	    StringBuffer sb = new StringBuffer();
	    String s;
	    while ((s = conn.nextLine()) != null) {
		sb.append(s);
		sb.append("\n");
	    }
	    info = sb.toString();

	    return showUpdate;
	} 
	catch (IOException e) {
	    throw(e);
	}
	finally {
	    conn.close();
	}
    }

    public String getInfo()
    {
	return info;
    }

    public long getReleaseNr()
    {
	return currentReleaseNr;
    }

    public String getVersion()
    {
	return currentVersion;
    }

    public InputStream connect() throws IOException
    {
	HttpConnection conn = new HttpConnection();
	conn.connect(prefs.getXNapJarURL());
	return conn.getInputStream();
    }

    public File save(InputStream in) throws IOException
    {
	File jarFile = XNapLoader.getXNapJar();
	boolean writeProperties = false;
	if (jarFile == null) {
	    jarFile = new File(FileHelper.getHomeDir("jars") + "xnap.jar");
	    writeProperties = true;
	}
	File tempFile = new File(jarFile.getAbsolutePath() + ".part");

	HttpConnection.save(in, tempFile.getAbsolutePath());

	if (jarFile.exists()) {
	    if (!jarFile.delete()) {
		throw new IOException(XNap.tr("Could not delete existing jar."));
	    }
	}

	if (!tempFile.renameTo(jarFile)) {
	    throw new IOException(XNap.tr("Could not rename file."));
	}

	if (writeProperties) {
	    Properties props = new Properties();
	    props.put("version", getVersion());
	    props.put("releaseNr", getReleaseNr() + "");
	    File f = new File(jarFile.getAbsolutePath() + ".properties");
	    logger.debug("writing version: " + f);
	    FileHelper.writeProperties(f, props);
	}

	return jarFile;
    }

}
