/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util.prefs;

import org.apache.log4j.Logger;

public class IntValidator implements Validator
{

    //--- Data field(s) ---

    private int min;
    private int max;

    //--- Constant(s) ---

    public IntValidator(int min, int max)
    {
	this.min = min;
	this.max = max;
    }

    public IntValidator(int min)
    {
	this(min, Integer.MAX_VALUE);
    }

    public IntValidator()
    {
	this(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    //--- Method(s) ---

    /**
     * Validates <code>String</code>.
     * @exception IllegalArgumentException if newValue is invalid.
     */
    public void validate(String value)
    {
	int i = Integer.parseInt(value);
	if (i < min || i > max) {
	    throw(new IllegalArgumentException("Value out of range."));
	}
    }

}
