/*
 * video.h
 *
 * Copyright (C) 1998 Rasca, Berlin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <linux/types.h>
#include <linux/videodev.h>
#include <fcntl.h>

typedef struct vid_dev {
	int fd;
	char name[32];
	int type;
	int channels;
	int audios;
	int maxwidth;
	int maxheight;
	int minwidth;
	int minheight;
	/* */
	int frames;
	int size;
	int xx;
	char *mmap;
	/* picture */
	unsigned short brightness;
	unsigned short hue;
	unsigned short colour;
	unsigned short contrast;
	unsigned short whiteness;
	unsigned short depth;
	unsigned short palette;
} VIDEO;

VIDEO *video_open (const char *, int flags);
int video_close (VIDEO *);
int video_caps (VIDEO *);
int video_mmap (VIDEO *, int map);

