/*
 *               In the name of Allah
 * This file is part of The Zekr Project. Use is subject to
 * license terms.
 *
 * Author:         Mohsen Saboorian
 * Start Date:     Sep 3, 2004
 */

package net.sf.zekr.common.config;

import net.sf.zekr.common.runtime.Naming;


/**
 * This class contains Zekr directory hierarchy. Directories names are stored in uppercase
 * variables (by convention). Each directory end with a <code>DIR_DELIM</code> which is
 * equal to java <code>File.separator</code>.
 * 
 * @author Mohsen Saboorian
 * @since Zekr 1.0
 */
public class ApplicationPath {
	private static ResourceManager rm = ResourceManager.getInstance();

	// Directories
	public static final String RESOURCE_DIR = rm.getString("resource.baseDir");
	public static final String IMAGE_DIR = rm.getString("image.baseDir");
	public static final String ICON_DIR = rm.getString("icon.baseDir");
//	public static final String CONFIG_DIR = RESOURCE_DIR + "/config";
//	public static final String LIB_CONFIG_DIR = rm.getString("config.lib");

	/**
	 * This is the directory containing quran source and other related sources.
	 */
	public static final String TEXT_DIR = rm.getString("text.quran.baseDir");
	public static final String TRANSLATION_DIR = rm.getString("text.trans.baseDir");
	public static final String TRANSLATION_DESC = rm.getString("text.trans.desc");

	/**
	 * The directory relative path, containing language packs and language settings.
	 */
	public static final String LANGUAGE_DIR = rm.getString("lang.baseDir");

	public static final String UI_DIR = rm.getString("ui.baseDir");
	public static final String THEME_DIR = rm.getString("theme.baseDir");
	public static final String THEME_DESC = rm.getString("theme.desc");

	// Files

	// XML Files
//	public static final String XML_CONFIG = rm.getString("config.zekr");
	public static final String MAIN_CONFIG = rm.getString("config.original"); // original config
	public static final String USER_CONFIG = rm.getString("config.user", new String[]{Naming.CONFIG_DIR}); // user customized config

	public static final String BOOKMARK_DIR = rm.getString("bookmark.baseDir");
//	public static final String MAIN_BOOKMARK = rm.getString("bookmark.original"); // original bookmarks
//	public static final String BUILTIN_USER_BOOKMARK = rm.getString("bookmark.user", new String[]{Naming.CONFIG_PATH}); // user customized bookmarks

	// Velocity Files
//	/**
//	 * Please note that this string contains only the file name, not the full path,
//	 * because <code>Velocity.getTemplate()</code> works for directories added to
//	 * <code>"file.resource.loader.path"</code> property.
//	 */

	// Log4J Property Files
	public static final String DEFAULT_LOGGER = rm.getString("config.logger");

	// Velocity Property Files
	public static final String VELOCITY_CONFIG = rm.getString("config.template");


}
