# -*- coding: utf-8 -*-

import re, sys, os.path

from RestrictedManager.core import DriverHandler

from gettext import gettext as _

class SlModem(DriverHandler):
    is_handler = True

    name = "snd-intel8x0m"
    rationale = _("This driver, together with the sl-modem-daemon package, "
                  "enables the usage of many software modems, as commonly found "
                  "in laptops.\n\n"
                 "If this driver is not enabled, you will not be able to use "
                 "your modem.")

    driver_package = 'sl-modem-daemon'

    def description(self):
        return _("Software modem driver")

    def is_hw_available(self):
        """Check /proc/asound/cards for a "Modem" card."""
        
        modem_re = re.compile('^\s*\d+\s*\[Modem\s*\]')
        try:
            for l in open('/proc/asound/cards'):
                if modem_re.match(l):
                    return True
        except IOError:
            print >> sys.stderr, 'Error: could not open /proc/asound/cards'

        return False

    def is_enabled(self):
        return self.package_installed(self.driver_package)

    def is_loaded(self):
        return self.is_enabled() and os.path.exists('/dev/modem')

    def enable(self):
        self.install_package(self, self.driver_package)

    def disable(self):
        self.remove_package(self, self.driver_package)

