#!/usr/bin/python

from distutils.core import setup, Extension
from distutils.command.clean import clean
from distutils.dir_util import remove_tree
import subprocess, glob, os.path, shutil

# for kcm modules building
import kdedistutils

mo_files = []
# HACK: make sure that the mo files are generated and up-to-date
subprocess.call(["make", "-C", "po", "build-mo"])
for filepath in glob.glob("po/mo/*/LC_MESSAGES/*.mo"):
    lang = filepath[len("po/mo/"):]
    targetpath = os.path.dirname(os.path.join("share/locale",lang))
    mo_files.append((targetpath, [filepath]))

# build .py files from the .ui files.
for file in glob.glob("data/*.ui"):
    subprocess.call(["kdepyuic", file])
    shutil.move(file[5:-3]+".py","RestrictedManager/")
# patch ManagerWindowKDE.py for kcm-specific fixes
subprocess.call(["patch", "-p1", "-i" "data/kcm-fix.patch"])

class RMClean(clean):
    ''' cleans up the hacks above, mostly '''
    def run(self):
        clean.run(self)
        if os.path.exists('build/'):
            remove_tree('build/')
        generated_files = ['applications/kde/kcm_restricted-manager.cpp' , 'RestrictedManager/ManagerWindowKDE.py',
                        'RestrictedManager/FwHandlerBcm.py', 'RestrictedManager/FwHandlerProgress.py']
        for file in generated_files:
            if os.path.exists(file):
                os.remove(file)

kdedistutils.setup(
    name="restricted-manager",
    author="Scott James Remnant",
    author_email="scott@ubuntu.com",
    maintainer="Martin Pitt",
    maintainer_email="martin.pitt@ubuntu.com",
    url="http://www.ubuntu.com",
    license="gpl",
    description="check, enable, and disable non-free hardware drivers",
    packages=["RestrictedManager", "RestrictedManager/handlers"],
    data_files=[("share/restricted-manager", glob.glob("RestrictedManager/*.glade")),
                ("share/restricted-manager/groups", glob.glob("groups/*")),
                ("share/applications", glob.glob("applications/*.desktop")),
                ("share/applications/kde", glob.glob("applications/kde/*.desktop")),
                ("/etc/xdg/autostart", glob.glob("autostart/*.desktop")),
               ] + mo_files,
    scripts=["restricted-manager","restricted-manager-kde"],
    kcontrol_modules = [ ('applications/kde/restricted-manager-kde.desktop.in', 'RestrictedManagerKDE')],
    cmdclass = { 'clean' : RMClean }
)


