function Heal() {}

Heal.prototype.Schema = 
	"<a:help>Controls the healing abilities of the unit.</a:help>" +
	"<a:example>" +
		"<Range>20</Range>" +
		"<HP>5</HP>" +
		"<Rate>2000</Rate>" +
		"<UnhealableClasses datatype=\"tokens\">Cavalry</UnhealableClasses>" +
		"<HealableClasses datatype=\"tokens\">Support Infantry</HealableClasses>" +
	"</a:example>" +
	"<element name='Range' a:help='Range (in metres) where healing is possible'>" +
		"<ref name='nonNegativeDecimal'/>" +
	"</element>" +
	"<element name='HP' a:help='Hitpoints healed per Rate'>" +
		"<ref name='nonNegativeDecimal'/>" +
	"</element>" +
	"<element name='Rate' a:help='A heal is performed every Rate ms'>" +
		"<ref name='nonNegativeDecimal'/>" +
	"</element>" +
	"<element name='UnhealableClasses' a:help='If the target has any of these classes it can not be healed (even if it has a class from HealableClasses)'>" +
		"<attribute name='datatype'>" +
			"<value>tokens</value>" +
		"</attribute>" +
		"<text/>" +
	"</element>" +
	"<element name='HealableClasses' a:help='The target must have one of these classes to be healable'>" +
		"<attribute name='datatype'>" +
			"<value>tokens</value>" +
		"</attribute>" +
		"<text/>" +
	"</element>";

Heal.prototype.Init = function()
{
};

Heal.prototype.Serialize = null; // we have no dynamic state to save

Heal.prototype.GetTimers = function()
{
	var prepare = 1000;
	var repeat = +this.template.Rate;

	var cmpTechMan = QueryOwnerInterface(this.entity, IID_TechnologyManager);
	if (cmpTechMan)
		repeat = cmpTechMan.ApplyModifications("Heal/Rate", repeat, this.entity);
	return { "prepare": prepare, "repeat": repeat };
};

Heal.prototype.GetRange = function()
{
	var min = 0;
	var max = +this.template.Range;

	var cmpTechMan = QueryOwnerInterface(this.entity, IID_TechnologyManager);
	if (cmpTechMan)
		max = cmpTechMan.ApplyModifications("Heal/Range", max, this.entity);

	return { "max": max, "min": min };
};

Heal.prototype.GetUnhealableClasses = function()
{
	var classes = this.template.UnhealableClasses._string;
	// If we have no unhealable classes defined classes is undefined
	return classes ? classes.split(/\s+/) : [];
};

Heal.prototype.GetHealableClasses = function()
{
	var classes = this.template.HealableClasses._string;
	return classes.split(/\s+/);
};

/**
 * Heal the target entity. This should only be called after a successful range 
 * check, and should only be called after GetTimers().repeat msec has passed 
 * since the last call to PerformHeal.
 */
Heal.prototype.PerformHeal = function(target)
{
	var cmpHealth = Engine.QueryInterface(target, IID_Health);
	if (!cmpHealth)
		return;
	
	var hp = +this.template.HP;
	var cmpTechMan = QueryOwnerInterface(this.entity, IID_TechnologyManager);
	if (cmpTechMan)
		hp = cmpTechMan.ApplyModifications("Heal/HP", hp, this.entity);
	var targetState = cmpHealth.Increase(hp);

	// Add XP
	var cmpLoot = Engine.QueryInterface(target, IID_Loot);
	var cmpPromotion = Engine.QueryInterface(this.entity, IID_Promotion);
	if (targetState!==undefined && cmpLoot && cmpPromotion)
	{
		// HP healed * XP per HP
		cmpPromotion.IncreaseXp((targetState.new-targetState.old)*(cmpLoot.GetXp()/cmpHealth.GetMaxHitpoints()));
	}
	//TODO we need a sound file
//	PlaySound("heal_impact", this.entity);
};

Engine.RegisterComponentType(IID_Heal, "Heal", Heal);
