#!/tools/ns/bin/perl5.6.1 -w
# --- BEGIN COPYRIGHT BLOCK ---
# This Program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; version 2 of the License.
# 
# This Program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along with
# this Program; if not, write to the Free Software Foundation, Inc., 59 Temple
# Place, Suite 330, Boston, MA 02111-1307 USA.
# 
# In addition, as a special exception, Red Hat, Inc. gives You the additional
# right to link the code of this Program with code not covered under the GNU
# General Public License ("Non-GPL Code") and to distribute linked combinations
# including the two, subject to the limitations in this paragraph. Non-GPL Code
# permitted under this exception must only link to the code of this Program
# through those well defined interfaces identified in the file named EXCEPTION
# found in the source code files (the "Approved Interfaces"). The files of
# Non-GPL Code may instantiate templates or use macros or inline functions from
# the Approved Interfaces without causing the resulting work to be covered by
# the GNU General Public License. Only Red Hat, Inc. may make changes or
# additions to the list of Approved Interfaces. You must obey the GNU General
# Public License in all respects for all of the Program code and other code used
# in conjunction with the Program except the Non-GPL Code covered by this
# exception. If you modify this file, you may extend this exception to your
# version of the file, but you are not obligated to do so. If you do not wish to
# provide this exception without modification, you must delete this exception
# statement from your version and license this file solely under the GPL without
# exception. 
# 
# 
# Copyright (C) 2001 Sun Microsystems, Inc. Used by permission.
# Copyright (C) 2005 Red Hat, Inc.
# All rights reserved.
# --- END COPYRIGHT BLOCK ---

$patchcmd = "swlist -l bundle";
# [output sample]
# Initializing...
# Contacting target "linux2"...
#
# Target:  linux2:/
#
#
# B6268AA      B.11.00.05     Graphics and Technical Computing Software 
# BUNDLE       B.11.00        Patch Bundle   
# HPUXEng64RT  B.11.00.01     English HP-UX 64-bit Runtime Environment 
# HWE1100      B.11.00.0206.5 Hardware Enablement Patches for HP-UX 11.00, June 2002 
# OnlineDiag   B.11.00.21.10  HPUX 11.0 Support Tools Bundle, Jun 2002 
# QPK1100      B.11.00.64.4   Quality Pack for HP-UX 11.00, March 2004 
# UnlimUserLic B.11.00.02     HP-UX Unlimited-User License 
# XSWGR1100    B.11.00.47.08  General Release Patches, November 1999 (ACE) 

%month2digit = (
    'January',   1,
    'February',  2,
    'March',     3,
    'April',     4,
    'May',       5,
    'June',      6,
    'July',      7,
    'August',    8,
    'September', 9,
    'October',   10,
    'November',  11,
    'December',  12,
);

open PATCHCMD, "$patchcmd|" or die "Error: could not open $patchcmd: $!";
sleep 1;

$qpk_str = "";
$month_year = "";
while (<PATCHCMD>) {
  chop;
  if (/^\s+(QPK.*), ([A-Za-z]* [12][0-9]*)/) {
    $qpk_str = $1;
    $month_year = $2;
  }
}
close PATCHCMD;

$date = gmtime;
$host = `hostname`;
chop $host;
$dom = `domainname`;
$un = `uname -a`;

print "/* This list was generated by $0 */\n";
print "/*   on $host.$dom */\n";
print "/*   at $date GMT */\n";
print "/* Here is the information from uname -a:\n";
print $un;
if ( $qpk_str eq "" )
{
    print " Quality Pack is not installed on the system. */\n";
}
else
{
    ($qpkname, $version, $description) = split(/[     ]+/, $qpk_str, 3);
    print "$qpkname\n";
    print "$version\n";
    print "$description\n";

    if ( $month_year eq "" )
    {
        print " Quality pack has no date info. */\n";
        print "$qpk_str <$month_year>\n";
    }
    else
    {
        ($month, $year) = split(/\s/, $month_year, 2);
        $mo = $month2digit{$month};
        print " The following is a Quality Pack installed on the system. */\n";
        print "{\"$qpkname\", \"$version\", \"$description\", $year, $mo, 0},\n";
    }
}
