//  ----------------------------------------------------------
//
//  Copyright (C) 2002 Brad Wasson <bard@systemtoolbox.com>
//
//  This file is part of 3ddesktop.
//
//  3ddesktop is free software; you can redistribute it and/or modify it
//  under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.
//
//  3ddesktop is distributed in the hope that it will be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with 3ddesktop; see the file COPYING.   If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef _EVENT_HPP
#define _EVENT_HPP

enum event_t {
    PROGRAM_START,
    ENTRY_MOVEMENT_START,
    ENTRY_MOVEMENT_STOP,
    EXIT_MOVEMENT_START,
    EXIT_MOVEMENT_STOP,
    GOTO_FACE_COMPLETE
};


class Event {
private:
public:
    // this is the event type that will trigger this event
    event_t type;

    void (*function) (Event *);

    void *data;

    int reoccurring;

    Event (event_t _type, 
           void (*_function)(Event *), 
           void *_data = NULL, 
           int _reoccurring = 0 ) 
    {
        type = _type;
        function = _function;
        data = _data;
        reoccurring = _reoccurring;
    };
    
    void activate () {
        function(this);
    };

};


class EventManager {
private:
    
    list <Event *> events;

public:
    EventManager() {};

    void trigger_event(event_t event) {
        // step through events and activate any that are this event.
        list<Event *>::iterator k;
        for (k = events.begin(); k != events.end(); ++k) {
            if ((*k)->type == event) {
                Event *e = *k;
                if (!e->reoccurring) 
                    events.erase(k++);

                e->activate();

                if (!e->reoccurring)
                    delete e;
            }
        }
    };

    void add_event (Event *e) {
        events.push_back(e);
    };

    void add_event (event_t type,
                    void (*function)(Event *),
                    void *data = NULL,
                    int reoccurring = 0) 
    {
        // deleted in trigger_event after activation
        Event *e = new Event (type, function, data, reoccurring);
        if (!e) {
            msgout (ERROR, "out of memory: Event\n");
            end_program(-1);
        }
        events.push_back(e);
    }
                    

};


#endif // _EVENT_HPP
