/* ------------------------------------------------------------------------
 * $Id: Math.hh,v 1.5 2001/08/16 11:32:20 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 1999-06-02 by Niklas Elmqvist.
 *
 * Copyright (c) 1999-2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _Math_hh_
#define _Math_hh_

// -- System Includes
#include <stdlib.h>
#include <math.h>
//#include <cmath>

// -- Namespaces

class Math {

public:
    
    /// Machine precision (@@@Put some research into this!)
    const static double tolerance = 1e-5;
    const static double epsilon = tolerance;
    
    // Value of pi 
    const static double pi = M_PI;
    
    // Degree <-> radian conversion
    const static double radians_per_degree = pi / 180.;
    const static double degrees_per_radian = 180. / pi;
    
    static double degToRad(double deg) { return deg * radians_per_degree; }
    static double radToDeg(double rad) { return rad * degrees_per_radian; }

    /// Absolute function 
    static float abs(float a) { return fabs(a); }
    static double abs(double a) { return fabs(a); }
    static int abs(int a) { return ::abs(a); }
    static long abs(long a) { return ::labs(a); }
				
    /// Equality function (with tolerance)
    template <class T, class U> static bool equal(T a, U b, T e = tolerance) {
	return a - b < e && b - a < e;
    }
    
};

#endif /* Math.hh */
