/* ------------------------------------------------------------------------
 * GeometryKitImpl.hh
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-08-01 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * Copyright (c) 2000, 2001 Steve Houston <steve@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _GeometryKitImpl_hh_
#define _GeometryKitImpl_hh_

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Nobel/GeometryKit.hh"

// -- Local Includes
#include "KitImpl.hh"

// -- Namespace Definitions

class GeometryKitImpl : public virtual POA_Nobel::GeometryKit, 
			public KitImpl {
public:
    
    /**
     * Default constructor.
     **/
    GeometryKitImpl() { }
    
    /**
     * Destructor
     **/ 
    virtual ~GeometryKitImpl() { }
    
    // IDL Functions
    virtual char *name() { return CORBA::string_dup("GeometryKit"); }
    virtual char *description() {
	return CORBA::string_dup("Geometry node component factory kit.");
    }
    virtual Nobel::LineGeometry_ptr createLineGeometry();
    virtual Nobel::PointGeometry_ptr createPointGeometry();
    virtual Nobel::TriangleGeometry_ptr createTriangleGeometry();
    virtual Nobel::Appearance_ptr createAppearance();

private:
    
    // No copy constructor for kits
    GeometryKitImpl(const GeometryKitImpl &kit);
};

#endif /* GeometryKitImpl.hh */
