/* ------------------------------------------------------------------------
 * $Id: NodeImpl.hh,v 1.16 2001/08/21 21:37:39 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-08-10 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _NodeImpl_hh_
#define _NodeImpl_hh_

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Polhem/EmitterImpl.hh"
#include "Nobel/Node.hh"

// -- Forward Declarations
class Mutex;

// -- Class Declarations

/**
 * Node base class (abstract). 
 **/
class NodeImpl : public virtual POA_Nobel::Node,
		 public EmitterImpl {
public:
    
    /**
     * Destructor.
     **/
    virtual ~NodeImpl() { }

    // IDL functions
    virtual Nobel::Tag insert(Nobel::Node_ptr n) { return 0; }
    virtual void remove(Nobel::Tag t) { }
    
    virtual Nobel::Transform_ptr transformation();
    virtual void traverse(Nobel::Visitor_ptr v);
    virtual void render(Nobel::Renderer_ptr r) = 0;
    virtual void pick(Nobel::Picker_ptr p) = 0;
    virtual Nobel::Volume_ptr getBoundingVolume();

    virtual void receive(const Nobel::Event &e);
    
protected:

    /**
     * Handle any node events. This is the default handling method of
     * all nodes, and takes care of normal node behavior like bounding
     * volume recomputation, etc.
     *
     * @param e event to handle.
     * @return true if the event is handled, false otherwise.
     **/
    virtual bool handleNodeEvents(const Nobel::Event &e);

    /**
     * Recompute the bounding volume for this node. This is usually
     * done by coalescing the bounding volumes of all the child nodes
     * and adding any necessary extra space to the volume. If the
     * bounding volume is changed, the node will emit a corresponding
     * event to any listeners/parents.
     **/
    virtual void recomputeBoundingVolume() { }

    /// Abstract base class, so constructor is hidden
    NodeImpl();

    /// Access mutex
    Mutex _mutex;
};

#endif /* NodeImpl.hh */
