/* ------------------------------------------------------------------------
 * ViewSlotImpl.hh
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-11-22 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * Copyright (c) 2000 Steve Houston <shouston@programmer.net>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _ViewSlotImpl_hh_
#define _ViewSlotImpl_hh_

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Nobel/ViewSlot.hh"
#include "Polhem/NodeImpl.hh"

// -- Forward Declarations
class TransformImpl;

// -- Class Declarations

/**
 * ViewSlot node class.
 **/
class ViewSlotImpl : public virtual POA_Nobel::ViewSlot, 
		     public NodeImpl {
 
public:

    /**
     * Default constructor.
     **/
    ViewSlotImpl();

    /**
     * Destructor.
     **/
    ~ViewSlotImpl();
    
    // IDL functions
    virtual Nobel::Transform_ptr transformation();
    virtual void traverse(Nobel::Visitor_ptr v);
    virtual void render(Nobel::Renderer_ptr r);
    virtual void pick(Nobel::Picker_ptr p);
    
private:

    /// Node transform 
    TransformImpl *_transform;    
};

#endif /* ViewSlotImpl.hh */

