/* ------------------------------------------------------------------------
 * $Id: Config.cc,v 1.1 2001/08/16 11:32:23 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-08-15 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------ 
 */

// -- Local Includes
//#include "Celsius/Mutex.hh"
#include "Celsius/Logger.hh"
#include "Celsius/SAX/Parser.hh"
#include "Celsius/SAX/ParserFactory.hh"
#include "Polhem/LogGroup.hh"
#include "Config.hh"

// -- Defaults
const int defaultScreenWidth = 640;
const int defaultScreenHeight = 480;
const int defaultScreenDepth = 16;

// -- Static Variable Initializations
int Config::_screenWidth 		= defaultScreenWidth;
int Config::_screenHeight 		= defaultScreenHeight;
int Config::_screenDepth 		= defaultScreenDepth;
std::vector<std::string> Config::_ruleFiles;
std::vector<std::string> Config::_logGroups;

// -- Code Segment

int parseInt(const std::string &s) 
{
    return strtol(s.c_str(), 0, 10);
}

void ConfigHandler::startElement(const std::string &name,
				 const SAX::AttributeList &atts)
{
    // Is this a screen element?
    if (name == "screen") {
	
	// Set values into the config database
	Config::_screenWidth = parseInt(atts.getValue("width"));
	Config::_screenHeight = parseInt(atts.getValue("height"));
	Config::_screenDepth = parseInt(atts.getValue("depth"));
    }
    else if (name == "eventRule") {
	
	// Add the file to the config database
	Config::_ruleFiles.push_back(atts.getValue("file"));
    }
    else if (name == "logGroup") {
	
	// Add the log group to the config database
	Config::_logGroups.push_back(atts.getValue("name"));
    }
}

void ConfigHandler::endElement(const std::string &name)
{
    // Do nothing
}

void Config::parse(const std::string &filename)
{
    ConfigHandler handler;
    
    // Emit some output
    Logger::log(LogGroup::Config) << "Parsing config file \""
				  << filename << "\"." << std::endl;

    // Create a new parser using the parser factory and configure it
    SAX::Parser *parser = SAX::ParserFactory::makeParser();
    parser->setDocumentHandler(&handler);

    try {
	// Parse the file
	parser->parse(filename);
    }
    catch (const SAX::ParseException &e) {
	Logger::log(LogGroup::Config) << filename << ":" << e.getLineNumber()
				      << ":" << e.getColumnNumber()
				      << ": " << e.what() << std::endl;
    }
    catch (const SAX::Exception &e) {
	Logger::log(LogGroup::Config) << "Error parsing \"" << filename 
				      << "\": " << e.what() << std::endl;
    }
    
    // Delete the parser before we leave
    delete parser;
}
