/* ------------------------------------------------------------------------
 * $Id: Plane3D.cc,v 1.4 2001/08/02 14:22:09 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-07-16 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- Local Includes
#include "Plane3D.hh"

// -- Code Segment

Plane3D::Plane3D(const Vector3D &p1, const Vector3D &p2, const Vector3D &p3,
		 bool ccw)
{
    // Compute vectors in the plane
    Vector3D v1 = p2 - p1;
    Vector3D v2 = p3 - p1;
    
    // Compute normal and normalize it
    Vector3D n = Vector3D::cross(v1, v2);
    n.normalize();
    
    // Flip direction of normal if necessary
    if (ccw == false) n = -n;

    // Compute "D" component using the negated dot product and one of
    // the triangle vertices (which is guarantueed to be on the plane)
    d() = -Vector3D::dot(n, p1);
    
    // Assign the rest of the plane components
    a() = n.x(); b() = n.y(); c() = n.z();
}

Plane3D::Plane3D(const Vector3D &n, const Vector3D &p)
    : _a(n.x()), _b(n.y()), _c(n.z())
{
    // Compute "D" component using the negated dot product and the
    // point on the plane
    d() = -Vector3D::dot(n, p);    
}

void Plane3D::transform(const Matrix3D &inv_trafo)
{
    // Create a vector that represents the plane and transform it
    Vector3D q(a(), b(), c(), d());
    q = q * inv_trafo;
    
    // Store back the values
    a() = q.x(); b() = q.y(); c() = q.z(); d() = q.w();
}
