/* ------------------------------------------------------------------------
 * $Id: AttributeListImpl.cc,v 1.1 2001/08/16 11:32:25 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * This C++ SAX implementation (Simple API for XML) is derived from
 * David Megginson's original Java SAX that can be found on 
 * http://www.megginson.com/SAX/.
 * ------------------------------------------------------------------------
 * File created 2001-08-14 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------ 
 */

// -- System Includes
#include <algorithm>

// -- Local Includes
#include "Celsius/SAX/AttributeListImpl.hh"

using namespace SAX;

// -- Code Segment

int AttributeListImpl::getLength() const
{
    return _data.size();
}

const std::string &AttributeListImpl::getName(int i) const 
{
    // Make sure the index is legal, then return the desired value
    static std::string empty;
    if (inRange(i)) return _data[i].name;
    else return empty;
}

const std::string &AttributeListImpl::getType(int i) const 
{
    // Make sure the index is legal, then return the desired value
    static std::string empty;
    if (inRange(i)) return _data[i].type;
    else return empty;
}

const std::string &AttributeListImpl::getType(const std::string &name) const
{
    // Search for the attribute with the given name
    static std::string empty;
    std::vector<attrib_t>::const_iterator i = 
	std::find(_data.begin(), _data.end(), name);
    
    // If we found it, return it, otherwise return an empty string
    if (i != _data.end()) return i->type;
    else return empty;
}

const std::string &AttributeListImpl::getValue(int i) const 
{
    // Make sure the index is legal, then return the desired value
    static std::string empty;
    if (inRange(i)) return _data[i].value;
    else return empty;
}

const std::string &AttributeListImpl::getValue(const std::string &name) const
{
    // Search for the attribute with the given name
    static std::string empty;
    std::vector<attrib_t>::const_iterator i = 
	std::find(_data.begin(), _data.end(), name);

    // If we found it, return it, otherwise return an empty string
    if (i != _data.end()) return i->value;
    else return empty;
}

void AttributeListImpl::addAttribute(const std::string &name,
				     const std::string &type,
				     const std::string &value) 
{
    // Create a new attribute entry
    attrib_t attrib;
    attrib.name = name;
    attrib.type = type;
    attrib.value = value;
    
    // Add it to the list of entries
    _data.push_back(attrib);
}

void AttributeListImpl::setAttributeList(const AttributeList &atts)
{
    // Clear this list
    clear();
    
    // Add attributes one at a time
    for (int i = 0; i < atts.getLength(); i++)
	addAttribute(atts.getName(i), atts.getType(i), atts.getValue(i));
}

void AttributeListImpl::removeAttribute(const std::string &name) 
{
    // Search for the attribute and erase it if found
    std::vector<attrib_t>::iterator i =
	std::find(_data.begin(), _data.end(), name);
    if (i != _data.end()) _data.erase(i);
}

void AttributeListImpl::clear() 
{
    _data.clear();
}

