/* ------------------------------------------------------------------------
 * $Id: lexer.ll,v 1.4 2001/06/29 15:00:43 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-06-12 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

%{
/* -- System Includes */
#include <string.h>

/* -- Local Includes */
#include "Defines.hh"
#include "AST.hh"
#include "grammar.h"

/* Current line number (defined in grammar.yy) */ 
extern int zorn_current_line;

/* Error output function */
extern void yyerror(const char *s);

%}

%% 

[0-9]+			{ 
				/* Convert the string to an integer */
				yylval.int_val = atoi(yytext); 
				return INT_LIT; 
			}

[0-9]*"."[0-9]*		{
				/* Convert the string to a double */
				yylval.double_val = atof(yytext);
				return DOUBLE_LIT; 
			}

\"[^$\"]*\"		{
				/* Retrieve the string, minus the quotes */
				char *str = strdup(yytext + 1);
				if (str[strlen(str) - 1] == '"')
					str[strlen(str) - 1] = '\0';
				yylval.string_val = str;
				return STR_LIT;
			}

if			{ return IF; }

then			{ return THEN; }

else			{ return ELSE; }

init			{ return INIT; }

true|false		{
				/* Parse the literal value of the boolean */
				yylval.int_val = strcmp(yytext, "true") == 0;
				return BOOL_LIT;
			}

[a-zA-Z][a-zA-Z0-9\.]*	{
				/* Get the string as the identifier name */
				yylval.string_val = strdup(yytext);
				return IDENTIFIER;
			}

"=="			{ return EQ; }
"!="			{ return NEQ; }
"<="			{ return LEQ; }
"=>"			{ return GEQ; }
"&&"			{ return AND; }
"||"			{ return OR; }

[=<>+:\-*/()!;,\.?]	{
				/* Return the ASCII value of the operator */
				return yytext[0]; 
			}

"#".*$			/* Eat up one-line comments */

[ \t]+			/* Eat up whitespace */

\n			{
				/* Keep track of the current line */
				zorn_current_line++;
			}

.			{
				#define BUFFER_LEN 1024
				char buffer[BUFFER_LEN];

				/* Matches any that slipped through */
				sprintf(buffer, "unrecognized character '%s'",
					yytext);
				yyerror(buffer);
			}

%%
