# Part of the A-A-P recipe executive: Testing of ":python" command

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

import sys, os, stat, shutil, string

def runaap(args):
    res = os.system("%s ..%sMain.py %s" % (sys.argv[1], os.sep, args))
    if res:
        print "Aap exited with error value %d" % res
    return res

os.chdir("rectest")

# Create a recipe to test whether the recipe scope is passed to build commands
# and reading a local variable before it is written results in a warning.

recipe = "rectest.aap"
aapout = "rectest.aap.out"

def cleanup():
    for n in [ recipe, aapout ]:
        try:
            os.remove(n)
        except:
            pass

cleanup()

f = open(recipe, "w")
f.write("""
var1 = toplevel
:python
 print "one space indent"
:python
	print "one tab indent"
   	print "space and tab indent"
all:
     :python
        print "spaces"
	print "tab"
   	print "spaces + tab"
""")
f.close()

def check_contents(fname, expected):
    f = open(fname)
    actual = f.read()
    f.close()
    if actual != expected:
	print ('File contents wrong for "%s":\n%s\n--- instead of ---\n%s\n---'
						   % (fname, actual, expected))
        return 1
    return 0

# The first time running should result in two files being copied.
res = runaap("-f %s > %s" % (recipe, aapout))

failed = res + check_contents(aapout,
"""one space indent
one tab indent
space and tab indent
spaces
tab
spaces + tab
""")

cleanup()

sys.exit(failed)


# vim: set sw=4 et sts=4 tw=79 fo+=l:
