# Part of the A-A-P recipe executive: Testing of automatic dependencies

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

#
# This test checks that the following works properly:
# - A C file is used as a source, it needs to be scanned for included files.
# - One of the included files is a target in a dependency.
# - If the dependency changes the included file to include other files than
#   before the list of dependencies must be redone.
# - The source file is in a subdirectory, it should find included headers
#   there.
#

import sys, os, shutil, glob, string

def runaap(args):
    return os.system("%s ..%sMain.py %s" % (sys.argv[1], os.sep, args))

os.chdir("rectest")

# Create a recipe with a different filetype for the target, so that a different
# build action will be used.
# Check that the right action is used.
rec = "rectest.aap"
out = "rectest.out"
tdir = "rectestdir"
inp = "%s/rectest.c" % tdir
incl1 = "%s/incl1.h" % tdir
incl2 = "%s/incl2.h" % tdir
incl3 = "%s/incl3.h" % tdir

def cleanup():
    for file in [ rec, out, inp, incl1, incl2, incl3 ]:
	try:
	    os.remove(file)
	except:
	    pass
    try:
        shutil.rmtree(tdir)
    except:
        pass
    try:
	for dir in glob.glob('build-*'):
	    shutil.rmtree(dir)
    except:
	pass

cleanup()
os.mkdir(tdir)

inptext = """
CC = ignore_this    # disable using gcc for dependency check
INCLUDE = %s
MESSAGE =           # be silent

all: %s
        f = $BDIR/$(source).aap
        :print (((`file2string(f)`)))
%s :
        :print $(#)include "%s" >! $target
""" % (tdir, inp, incl1, incl2)

incl3_line = """        :print $(#)include "%s" >> $target
""" % incl3

# Create the source file that includes "incl1"
f = open(inp, "w")
f.write("""
#include <stdio.h>
#include "%s"
int main() { printf("Hello World!\\n"); return 0;}
""" % incl1)
f.close()

# Generate the header files.  "incl1" will be changed later.
for n in [incl1, incl2, incl3]:
    f = open(n, "w")
    f.write("""
    /* nothing */
    """)
    f.close()

def updatecheck(actual, name):
    expected = '- updating target "%s"' % name
    if string.find(actual, expected) < 0:
        print 'Did not find remark in log file: "%s"' % expected
        return 1
    return 0

def doit():
    res = 0
    for add_incl3, updated, scanned in [
            # should find correct dependencies.
                (0, [incl1, incl2], 1),
            # should find the same without dependency check
                (0, [incl1, incl2], 0),
            # should find third include file
                (1, [incl1, incl2, incl3], 1),
            # should not find third include file
                (0, [incl1, incl2], 1),
             ]:

        # Create the recipe.
        f = open(rec, "w")
        f.write(inptext)
        if add_incl3:
            f.write(incl3_line)     # Also include "incl3".
        f.close()

        if runaap("-f %s >%s" % (rec, out)):
            res = 1
        f = open("AAPDIR/log")
        logtext = f.read()
        f.close()
        
        for n in updated:
            res = res + updatecheck(logtext, n)

        # Check if correct dependencies were found.
        f = open(out)
        outtext = f.read()
        f.close()
        depline = outtext[string.find(outtext, "(((") + 3 :
                            string.find(outtext, ")))")]
        deps = string.split(depline)

        # All expected dependencies must be in output.
        for n in updated:
            if n not in deps:
                print 'Did not find dependency in Aap output: "%s"' % n
                print 'Actual dependencies: %s' % str(deps)
                res = 1
        # All dependencies in output must be expected.
        for n in deps:
            if n and n != ":" and n not in updated + [inp]:
                print 'Found extra dependency in Aap output: "%s"' % n
                print 'Actual dependencies: %s' % str(deps)
                res = 1

        idx = string.find(logtext, "Scanning")
        if scanned:
            if idx < 0:
                print 'Did not scan file'
                res = 1
        else:
            if idx >= 0:
                print 'Scanned file again unneccesarily'
                res = 1

    return res

res = doit()

cleanup()

sys.exit(res)


# vim: set sw=4 et sts=4 tw=79 fo+=l:
