!{\src2tex{textfont=tt}}
!!****f* ABINIT/print_ij
!! NAME
!! print_ij
!!
!! FUNCTION
!! Print ij_ symmetric matrixes in a "suitable" format
!! Data are "energy-like" in Hartree units.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  a_ij(adim)= input symmetric square matrix
!!  adim= dimension of array a_ij:
!!        adim=ndim*(ndim+1)/2                   if opt_packed=0
!!        adim=number of non-zero values of a_ij if opt_packed=1
!!  ndim= dimension of input square matrix
!!  opt_io= if opt_io=1, output to standard output only
!!          if opt_io=2, output to standard output and ab_out file
!!  opt_l= if <0  all parts of a_ij are printed
!!         if >=0 only parts of a_ij corresponding to li=lj=opt_l are printed
!!  opt_l_index(ndim)= array giving l quantum number for each 1<=ilmn<=ndim
!!                     not used if opt_l<0
!!  opt_pack= 1 if a_ij is in "packed storage"
!!              (i.e. only non-zero values are stored in array pr_dij)
!!  pack2ij(adim)= gives the (i,j) index of of packed value of rhoij
!!                 used only if opt_packed=1
!!  test_value= (real number) if positive, print a warning when the
!!              magnitude of a_ij is greater than opt_test
!!              No test when test_value<0
!!  unt= unit of output: if 1, no change (output is in Hartree)
!!                       if 2, output is in eV
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!
!! PARENTS
!!      hdr_io,pawdij,pawmkrhoij,pawprt,symdij,symrhoij
!!
!! CHILDREN
!!      wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine print_ij(a_ij,adim,ndim,opt_io,opt_l,opt_l_index,opt_pack,pack2ij,test_value,unt)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
#endif
!End of the abilint section

 implicit none

!Arguments ---------------------------------------------
!scalars
 integer,intent(in) :: adim,ndim,opt_io,opt_l,opt_pack,unt
 real(dp),intent(in) :: test_value
!arrays
 integer,intent(in) :: opt_l_index(ndim*min(1+opt_l,1)),pack2ij(adim*opt_pack)
 real(dp),intent(in) :: a_ij(adim)

!Local variables ---------------------------------------
! Adjust format bellow according to maxprt
!scalars
 integer,parameter :: maxprt=12
 integer :: ilmn,ilmn1,j0lmn,jlmn,jlmn1,klmn,nhigh,nmin
 real(dp) :: testval
 character(len=500) :: message
!arrays
 real(dp),allocatable :: b_ij(:),prtab(:,:)

! *************************************************************************

10 format(100(1x,f9.5))
11 format(12(1x,f9.5),a) !Change this format according to variable "maxprt"

 nmin=min(ndim,maxprt)
 if (opt_l>=0) nmin=count(opt_l_index(:)==opt_l)
 allocate(prtab(nmin,nmin))

!Eventually unpack input matrix
 allocate(b_ij(ndim*(ndim+1)/2))
 if (opt_pack==0) then
  b_ij=a_ij
 else
  b_ij=zero
  do klmn=1,adim
   b_ij(pack2ij(klmn))=a_ij(klmn)
  end do
 end if

!Transfer triangular matrix to rectangular one
 jlmn1=0
 do jlmn=1,ndim
  if (opt_l<0) then
   jlmn1=jlmn;if (jlmn1>nmin) cycle
  else if (opt_l_index(jlmn)==opt_l) then
   jlmn1=jlmn1+1
  else
   cycle
  end if
  ilmn1=0;j0lmn=jlmn*(jlmn-1)/2
  do ilmn=1,jlmn
   if (opt_l<0) then
    ilmn1=ilmn
   else if (opt_l_index(ilmn)==opt_l) then
    ilmn1=ilmn1+1
   else
    cycle
   end if
   klmn=j0lmn+ilmn
   prtab(jlmn1,ilmn1)=b_ij(klmn)
   prtab(ilmn1,jlmn1)=prtab(jlmn1,ilmn1)
  end do
 end do
 deallocate(b_ij)

 if (unt==2) prtab=prtab*Ha_eV

 if (ndim<=maxprt.or.opt_l>=0) then
  do ilmn=1,nmin
   write(message,fmt=10) prtab(ilmn,1:nmin)
   call wrtout(6,message,'COLL')
   if (opt_io==2) call wrtout(ab_out,message,'COLL')
  end do
 else
  do ilmn=1,nmin
   write(message,fmt=11) prtab(ilmn,1:nmin),' ...'
   call wrtout(6,message,'COLL')
   if (opt_io==2) call wrtout(ab_out,message,'COLL')
  end do
  write(message,'(3x,a,i2,a)') '...  only ',maxprt,'  components have been written...'
   call wrtout(6,message,'COLL')
   if (opt_io==2) call wrtout(ab_out,message,'COLL')
 end if

 if (test_value>zero) then
  testval=test_value;if (unt==2) testval=testval*Ha_eV
  nhigh=0;nhigh=count(abs(prtab(:,:))>=testval)
  if (nhigh>0) then
   write(message,'(5a,i3,a,f6.1,7a)')&
&   ' print_ij: WARNING -',ch10,&
&   '  The matrix seems to have high value(s) !',ch10,&
&   '  (',nhigh,' components have a value greater than ',testval,').',ch10,&
&   '  It can cause instabilities during SCF convergence.',ch10,&
&   '  Action: you should check your atomic dataset (psp file)',ch10,&
&   '          and look for "high" projector functions...'
   call wrtout(6,message,'COLL')
   if (opt_io==2) call wrtout(ab_out,message,'COLL')
  end if
 end if

 deallocate(prtab)

end subroutine print_ij
!!***
