!!****h* BigDFT/lazy_40
!! NAME
!!   lazy_40
!!
!! FUNCTION
!!   Filters for interpolating scaling functions (order 40)
!!
!! SOURCE
!!
integer, parameter :: m=42
real(dp), dimension(-m:m) :: ch = (/ &
     0._dp, 0._dp, 0._dp, &
     -2.33895335687458837e-13_dp,0._dp,9.61499474542229436e-12_dp,0._dp,&
     -1.9312403731519637e-10_dp,0._dp,2.52621846791090201e-9_dp,0._dp,&
     -2.42028027409528354e-8_dp,0._dp,1.81103730854716044e-7_dp,0._dp,&
     -1.10227332483179024e-6_dp,0._dp,5.61214589957214346e-6_dp,0._dp,&
     -0.0000244006343459658411_dp,0._dp,0.0000920510703104425647_dp,0._dp,&
     -0.000305221969976730609_dp,0._dp,0.000899343879450152758_dp,0._dp,&
     -0.00237826492565707063_dp,0._dp,0.00569939227746221067_dp,0._dp,&
     -0.0125090557778066702_dp,0._dp,0.0254814099177543281_dp,0._dp,&
     -0.0491427191270976329_dp,0._dp,0.0930820915230908105_dp,0._dp,&
     -0.189611667917407207_dp,0._dp,0.628712372568244948_dp,1._dp,0.628712372568244948_dp,&
     0._dp,-0.189611667917407207_dp,0._dp,0.0930820915230908105_dp,0._dp,&
     -0.0491427191270976329_dp,0._dp,0.0254814099177543281_dp,0._dp,&
     -0.0125090557778066702_dp,0._dp,0.00569939227746221067_dp,0._dp,&
     -0.00237826492565707063_dp,0._dp,0.000899343879450152758_dp,0._dp,&
     -0.000305221969976730609_dp,0._dp,0.0000920510703104425647_dp,0._dp,&
     -0.0000244006343459658411_dp,0._dp,5.61214589957214346e-6_dp,0._dp,&
     -1.10227332483179024e-6_dp,0._dp,1.81103730854716044e-7_dp,0._dp,&
     -2.42028027409528354e-8_dp,0._dp,2.52621846791090201e-9_dp,0._dp,&
     -1.9312403731519637e-10_dp,0._dp,9.61499474542229436e-12_dp,0._dp,&
     -2.33895335687458837e-13_dp,&
     0._dp, 0._dp, 0._dp   /)
real(dp), dimension(-m:m) ::  cg,cht,cgt

!******** coefficients for wavelet transform *********************
do i=-m,m
   cht(i)=0._dp
   cg(i)=0._dp
   cgt(i)=0._dp
enddo

! the normalization is chosen such that a constant function remains the same constant 
! on each level of the transform

cht( 0)=1._dp

! g coefficients from h coefficients
do i=-m,m-1
   cg(i+1)=cht(-i)*(-1)**(i+1)
   cgt(i+1)=ch(-i)*(-1)**(i+1)
enddo
!!***

