!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_coh
!! NAME
!! calc_coh
!!
!! FUNCTION
!!
!! COPYRIGHT
!! Copyright (C) 2005-2007 ABINIT group (FB)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  (to be filled)
!!
!! OUTPUT
!!  (to be filled)
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!      csigme
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine calc_coh(nr,npwx,npwc,ngfft1a,ngfft1,ngfft2,ngfft3,&
&                   gvec,epsm1q_o,qbzpg,i_sz,iqibz,jb,kb,wfg2_jk,sigcohme)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iqibz,jb,kb,ngfft1,ngfft1a,ngfft2,ngfft3,npwc,npwx,nr
 real(dp),intent(in) :: i_sz
 complex,intent(out) :: sigcohme
!arrays
 integer,intent(in) :: gvec(3,npwx)
 real(dp),intent(in) :: qbzpg(npwx)
 complex,intent(in) :: epsm1q_o(npwc,npwc),wfg2_jk(nr)

!Local variables-------------------------------
!scalars
 integer :: ig,ig4,ig4x,ig4y,ig4z,igp
!arrays
 complex :: epsm1q_qpg2(npwc,npwc)

! *************************************************************************

!DEBUG
!write(6,*)' calc_coh : enter '
!ENDDEBUG

 sigcohme=zero

!set up \epsilon^{-1} / |q+G|.|q+G'|
  do igp=1,npwc
   do ig=1,npwc
    epsm1q_qpg2(ig,igp)=epsm1q_o(ig,igp)/(qbzpg(ig)*qbzpg(igp))
   end do
  end do
!treat the case q->0 adequately
  if(iqibz==1) then
   if(jb==kb) then
     epsm1q_qpg2(1,1)=epsm1q_o(1,1)*i_sz
     epsm1q_qpg2(2:npwc,1)=zero
     epsm1q_qpg2(1,2:npwc)=zero
   else
    epsm1q_qpg2(:,1)=zero
    epsm1q_qpg2(1,:)=zero
   end if
  end if

   do igp=1,npwc
    do ig=1,npwc
     ig4x=modulo(gvec(1,igp)-gvec(1,ig),ngfft1)
     ig4y=modulo(gvec(2,igp)-gvec(2,ig),ngfft2)
     ig4z=modulo(gvec(3,igp)-gvec(3,ig),ngfft3)
     ig4=1+ig4x+ig4y*ngfft1a+ig4z*ngfft1a*ngfft2


     sigcohme=sigcohme + half*wfg2_jk(ig4)*epsm1q_qpg2(ig,igp)
    end do
   end do

end subroutine calc_coh
!!***
