!{\src2tex{textfont=tt}}
!!****f* ABINIT/cppm1par
!! NAME
!! cppm1par
!!
!! FUNCTION
!! Calculate the plasmon-pole parameters
!! big-omega-twiddle-squared and omega-twiddle from
!! epsilon-twiddle^-1 calculated for nomega (usually 2) frequencies omega=0 and omega=iE0.
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  epsm1(npwvec,npwvec,nomega,nq)=dielectric matrix at nomega frequencies, and nq wavevectors
!!  npwvec=number of plane waves
!!  nomega=number of frequencies (usually 2)
!!  nq=number of q points
!!  omega(nomega)=frequencies
!!  omegaplasma=input variable
!!
!! OUTPUT
!!  bigomegatwsq(npwvec,npwvec,nq)=parameter of the plasmon-pole model (see gwa.pdf file)
!!  omegatw(npwvec,npwvec,nq)=parameter of the plasmon-pole model (see gwa.pdf file)
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

 subroutine cppm1par(npwvec,nq,nomega,epsm1,omega,bigomegatwsq,omegatw,&
& omegaplasma)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nomega,npwvec,nq
 real(dp),intent(in) :: omegaplasma
!arrays
 complex,intent(in) :: epsm1(npwvec,npwvec,nomega,nq),omega(nomega)
 complex,intent(out) :: bigomegatwsq(npwvec,npwvec,nq)
 complex,intent(out) :: omegatw(npwvec,npwvec,nq)

!Local variables-------------------------------
!scalars
 integer :: ig,igp,io,io0,ioe0,iq
 real(dp) :: e0,minomega
 character(len=500) :: message
!arrays
 real(dp) :: q(3,nq),qplusg(npwvec)
 complex,allocatable :: a(:,:),omegatwsq(:,:)

! *************************************************************************

 write(message,'(a)') ' cppm1par : enter '
 call wrtout(06,message,'COLL')

 allocate(a(npwvec,npwvec),omegatwsq(npwvec,npwvec))

!find omega=0 and omega=imag (closest to omegaplasma) where to fit ppm parameters
 minomega=1.0d-3
 io0=0
 do io=1,nomega
   if(abs(omega(io))<minomega) then
     io0=io
     minomega=abs(omega(io))
   end if
 end do
 if(io0==0) stop 'omega=0 not found'
 minomega=1.0d-3
 e0=200.0
 ioe0=0
 do io=1,nomega
   if(real(omega(io))<minomega .and. aimag(omega(io))>minomega) then
    if(abs(aimag(omega(io))-omegaplasma)<abs(e0-omegaplasma)) then
     ioe0=io
     e0=aimag(omega(io))
    end if
   end if
 end do
 if(ioe0==0) stop 'omega imag not found'


 do iq=1,nq

!  calculate plasmon-pole A parameter A = epsilon^-1(0) - delta
   a(:,:)=epsm1(:,:,io0,iq)
   do ig=1,npwvec
     a(ig,ig)=a(ig,ig)-1.0
   end do

!  calculate plasmon-pole omega-twiddle-squared parameter
   omegatwsq(:,:)=(a(:,:)/(epsm1(:,:,io0,iq)-epsm1(:,:,ioe0,iq))-1.0)*e0**2

!  If omega-twiddle-squared is negative,
!  set omega-twiddle-squared to 1.0 (a reasonable way of treating
!  such terms, in which epsilon**-1 was originally increasing
!  along this part of the imaginary axis)
!  (note: originally these terms were ignored in Sigma; this was
!  changed on 6 March 1990.)
   do igp=1,npwvec
     do ig=1,npwvec
       if(real(omegatwsq(ig,igp))<=0.0) omegatwsq(ig,igp)=1.0
     end do
   end do

!  calculate omega-twiddle
!  we neglect the imag part (if one) in omega-twiddle-squared
   omegatw(:,:,iq)=sqrt(real(omegatwsq(:,:)))

!  calculate big-omega-twiddle-squared = -omega-twiddle-squared A
   bigomegatwsq(:,:,iq)=-a(:,:)*omegatw(:,:,iq)**2

 end do

 deallocate(a,omegatwsq)

!DEBUG
!write(*,*)'omega twiddle minval and location',minval(abs(omegatw(:,:,:)))*Ha_eV
!write(*,*)'omega twiddle min location',minloc(abs(omegatw(:,:,:)))
!write(*,*)'omega twiddle (16,15,1)=',omegatw(16,15,1)*Ha_eV
!write(*,*)'epsm1 (16,15,:,1)=',epsm1(16,15,:,1)
!write(*,*)'omega twiddle (19,15,5)=',omegatw(19,15,5)*Ha_eV
!write(*,*)'epsm1 (19,15,:,5)=',epsm1(19,15,:,5)
!ENDDEBUG

 write(message,'(a)') ' cppm1par : exit '
 call wrtout(06,message,'COLL')

 end subroutine cppm1par
!!***
