!{\src2tex{textfont=tt}}
!!****f* ABINIT/rdldaabinit
!! NAME
!! rdldaabinit
!!
!! FUNCTION
!!  Read abinit old format wf file (now superceded by KSS file)
!!  Because this file is obsolete, the input/output description is not up to date
!!
!!
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!! iunit=unit file number
!! nopx: maximum number of symmetry operations, i.e. dimension of op
!! nbx: maximum number of bands, i.e. dimension of en, occ, wf
!! nkx: maximum number of k-points in IBZ, i.e. dim. of kvec, en, occ, wf
!! ngx: maximum number of G-vectors in calculation, i.e. dim. of gvec, wf
!! nwx: maximum number of plane-waves to be used for wave-functions
!! nop: number of symmetry operations contained in file
!! nb: number of bands contained in file
!! nk: number of k-points in IBZ contained in file
!! ng: number of G-vectors in calculation contained in file
!!
!! OUTPUT
!! tit: 2*80-character description of LDA input file
!! i*: flags
!! a1, a2, a3: real-space lattice vectors in au
!! b1, b2, b3: reciprocal-space lattice vectors in au**-1
!! ucvol: unit cell volume in au**3
!! bzvol: reciprocal cell volume
!! op: symmetry operation matrices
!! gvec: RL vectors G
!! kibz: k-points in IBZ
!! en: LDA energies (Hartrees)
!! occ: occupations of bands (2.0=full)
!! wf: LDA wave functions (G) in plane wave order [Norm:|vector|=1]
!! n*r: number of*read from file
!! if nb<nbx then nbr=nb else nbr=nbx
!! if ng<ngx then ngr=ng else ngr=ngx
!! if ng<nwx then nwr=ng else nwr=nwx
!! if nop<nopx then nopr=nop else nopr=nopx
!! **if nk<nkx then nkr=nk else ERROR**:
!!  due to the structure of LDA file with regard of energies and
!!  occupations, (all energies/occupations in one record) it is
!!  !impossible to read nkx less than nk elements; implicit do in
!!  those sections is not synctactically correct and explicit do
!!  doesn''t go as look for EOR at each loop.
!! check the return value of nop, nb, ng to see how many elements
!! were loaded
!!
!! TODO
!! Follow abinit rules, including allocate instead of automatic arrays
!!
!! PARENTS
!!      screening,sigma
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine rdldaabinit(iunit,nopx,nbx,nkx,ngx,nwx,tit,a1,a2,a3,op,gvec,&
& kibz,en,occ,wfg)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iunit,nbx,ngx,nkx,nopx,nwx
!arrays
 integer,intent(out) :: gvec(3,ngx)
 real(dp),intent(out) :: a1(3),a2(3),a3(3),en(nkx,nbx),kibz(3,nkx),occ(nkx,nbx)
 real(dp),intent(out) :: op(3,3,nopx)
 complex,intent(out) :: wfg(nwx,nbx,nkx)
 character(len=80),intent(out) :: tit(2)

!Local variables-------------------------------
!scalars
 integer :: i,i1,i10,i11,i12,i13,i14,i15,i16,i2,i3,i4,i5,i6,i7,i8,i9,ib,ibp
 integer :: idum,ig,ik,istat,isym,isymend,isymin,j,k,nb,nbr,nbw,ng,ngr,nk,nkr
 integer :: nop,nopr,nwr
 real(dp) :: bzvol,cinf,csup,dum,einf,esup,fermie,sum,ucvol
 complex :: cdum
 logical,parameter :: debug=.true.,verbose=.false.
!arrays
 integer :: symrel(3,3,nopx)
 real(dp) :: b1(3),b2(3),b3(3),kpt(3,nkx),rprimd(3,3),wfd1(nwx),wfd2(nwx)

! *************************************************************************

 write(*,*) 'opening qplda input file (abinit unformatted form)'
!open(iunit,status='unknown',form='unformatted')
 rewind(iunit)

 write(*,*) 'title:'
 read(iunit) tit(1)
 read(iunit) tit(2)
 write(6,'(a80,/,a80)') tit(1),tit(2)
 write(*,*)

!skipping flags
 read(iunit)

 write(*,*)&
& 'real-space lattice primitive vectors, cartesian coordinates a.u. [Bohr]:'

 read(iunit) rprimd
 a1(:)=rprimd(:,1)
 a2(:)=rprimd(:,2)
 a3(:)=rprimd(:,3)
!The use of tol10 improves the transferability
 write(*,'(a,3f7.2,2(/,a,3f7.2))')' a1 = ',a1+tol10,&
& ' a2 = ',a2+tol10,' a3 = ',a3+tol10

 if(verbose) then
!  calculate Brillouin zone and Unit cell volumes
   ucvol=a1(1)*(a2(2)*a3(3)-a2(3)*a3(2))+&
&   a1(2)*(a2(3)*a3(1)-a2(1)*a3(3))+a1(3)*(a2(1)*a3(2)-a2(2)*a3(1))
   bzvol=8*pi*pi*pi/ucvol

!  calculate reciprocal-space lattice vectors b1-b3
   b1(1)=2.0*pi*(a2(2)*a3(3)-a2(3)*a3(2))/ucvol
   b1(2)=2.0*pi*(a2(3)*a3(1)-a2(1)*a3(3))/ucvol
   b1(3)=2.0*pi*(a2(1)*a3(2)-a2(2)*a3(1))/ucvol
   b2(1)=2.0*pi*(a3(2)*a1(3)-a3(3)*a1(2))/ucvol
   b2(2)=2.0*pi*(a3(3)*a1(1)-a3(1)*a1(3))/ucvol
   b2(3)=2.0*pi*(a3(1)*a1(2)-a3(2)*a1(1))/ucvol
   b3(1)=2.0*pi*(a1(2)*a2(3)-a1(3)*a2(2))/ucvol
   b3(2)=2.0*pi*(a1(3)*a2(1)-a1(1)*a2(3))/ucvol
   b3(3)=2.0*pi*(a1(1)*a2(2)-a1(2)*a2(1))/ucvol

   write(6,'(/,a,/,(5x,3f12.6))')&
&   ' calculated reciprocal lattice vectors in cartesians [au]:',b1,b2,b3
   write(6,'(2(/,a,f12.6,a))')&
&   ' brillouin zone volume = ',bzvol,' [au]',&
&   ' unit cell volume      = ',ucvol,' [au]'
 end if
 write(*,*)


!reading symmetry operations
!read symmetry operations (real-space-lattice units) and CONVERT
!to reciprocal-lattice units   [nop+1 lines]
![Note: if R is the matrix in lattice units, then the corresponding
!matrix in RL units is transpose(R**-1).  But since the set of
!operations contains inverse pairs, we only need to tranpose
!the matrices.  Thus op(J,I) rather than op(I,J).]

 write(*,*) 'symmetry operations'

 read(iunit) nop

 write(*,*) 'number of symmetry operations',nop

 if(nop<=nopx) then
   nopr=nop
 else
   write(*,*) 'warning rdlda 3: reading only a number of ',&
&   'symmetry operations ',nopx
   nopr=nopx
 end if

 read(iunit) (((symrel(j,i,k),i=1,3),j=1,3),k=1,nopx)
 op(:,:,:)=symrel(:,:,:)

 write(*,*) 'symmetry operations [reciprocal lattice units]:'
 do isymin=1,nopr,8
   isymend=isymin+7
   if(isymend>nopr) isymend=nopr
   do i=1,3
     write(6,'(7(3i3,1x),3i3)') ((symrel(i,j,isym),j=1,3),isym=isymin,isymend)
   end do
   write(*,*)
 end do



!reading reciprocal lattice vectors (in reciprocal lattice units)
!ie in the basis of the reciprocal lattice basis vectors

 write(*,*) 'reciprocal lattice vectors'

 read(iunit) ng

 write(*,*) 'number of G vectors found, i.e. of plane waves ',ng

 if(ng<=ngx) then
   ngr=ng
 else
   ngr=ngx
 end if
 write(*,*) 'reading a number of G vectors ',ngr

 read(iunit) ((gvec(i,ig),i=1,3),ig=1,ngx)

 write(6,'(a,/,5(i5,a,3i3))') ' G vectors [reciprocal lattice units]:',&
& (ig,':',(gvec(i,ig),i=1,3),ig=1,ngr)
 write(*,*)


!reading k-points in r.l. units

 write(*,*) 'k-points'

 read(iunit) nk

 write(*,*) 'number of k-points ',nk

 if(nk<=nkx) then
   nkr=nk
 else
   nkr=nkx
   write (*,*)
   write (*,*) '**error rdlda 5: k dimension of vectors initialized at ',nkx
   write (*,*) '                  increase the dimension at ',nk
   stop
 end if
 if(nk/=nkx) stop 'nk read not equal nk input'

 read(iunit) ((kpt(i,ik),i=1,3),ik=1,nkx)
 kibz(:,:)=kpt(:,:)

 write(6,'(a,/,(i5,3f12.6))') ' k-points [reciprocal lattice units]:',&
& (ik,(kibz(i,ik),i=1,3),ik=1,nkr)
 write(*,*)


!reading energies [Hartrees] (in ascending order)

 write(*,*) 'reading energies'

 read(iunit) nb

 write(*,*) 'number of eigenvalues found ',nb

 if(nb<=nbx) then
   nbr=nb
 else
   nbr=nbx
 end if
 write(*,*) 'reading a number of eigenvalues ',nbr

 read(iunit) fermie

 do ik=1,nkx
   read(iunit) (en(ik,ib),ib=1,nbx)
   read(iunit) (occ(ik,ib),ib=1,nbx)
   do ib=1,nb
     read(iunit) (wfd1(ig),wfd2(ig),ig=1,nwx)
     if(ib<=nbx) then
       wfg(1:nwx,ib,ik)=cmplx(wfd1(:),wfd2(:))
     end if
   end do
 end do


 write(*,*) ' k       eigenvalues [eV]'
 do ik=1,nkr
   write(6,'(i3,7x,10f7.2,/,50(10x,10f7.2,/))') ik,(Ha_eV*en(ik,ib),ib=1,nbr)
 end do
 write(*,*)

 if(debug) then
 write(*,*) ' k       eigenvalues [Hartree]'
 do ik=1,nkr
   write(6,'(i3,7x,10f7.4,/,50(10x,10f7.4,/))') ik,(en(ik,ib),ib=1,nbr)
 end do
 write(*,*)
 end if

 write(*,'(a,f7.2)') ' Fermi energy ',fermie

 write(*,*) ' k       occupation'
 do ik=1,nkr
   write(6,'(i3,7x,10f7.2,/,50(10x,10f7.2,/))') ik,(occ(ik,ib),ib=1,nbr)
 end do
 write(*,*)


!reading wavefunctions
!(a(G), normalised to 1) and write to scratch file
!test on the normalization and orthgonalization
 einf=10e+24
 esup=-1.0
 cinf=10e+24
 csup=-1.0

 write(*,*) 'wavefunctions'


 do ik=1,nkx
!  test on the normalization of wavefunctions
   do ib=1,nbx
     sum=0.0
     do ig=1,nwx
       sum=sum+conjg(wfg(ig,ib,ik))*wfg(ig,ib,ik)
     end do
     if(sum<einf) einf=sum
     if(sum>esup) esup=sum
   end do
!  test on the orthogonalization of wavefunctions
   do ib=1,nbx
     do ibp=ib+1,nbx
       cdum=0.0
       do ig=1,nwx
         cdum=cdum+conjg(wfg(ig,ib,ik))*wfg(ig,ibp,ik)
       end do
       if(abs(cdum)<cinf) cinf=abs(cdum)
       if(abs(cdum)>csup) csup=abs(cdum)
     end do
   end do
 end do


 write(*,*) 'test on the normalization of the wavefunctions'
 write(6,'(a,f9.6,/,a,f9.6)')&
& ' min sum_G |a(n,k,G)| = ',einf,&
& ' max sum_G |a(n,k,G)| = ',esup
 write(*,*) 'test on the orthogonalization of the wavefunctions'
 write(6,'(a,f9.6,/,a,f9.6)')&
& ' min sum_G a(n,k,G)* a(n",k,G) = ',cinf,&
& ' max sum_G a(n,k,G)* a(n",k,G) = ',csup
 write(*,*)

!close (iunit)
 return
end subroutine rdldaabinit
!!***
