!{\src2tex{textfont=tt}}
!!****f* ABINIT/pointint
!! NAME
!! pointint
!!
!! FUNCTION
!! Computes the values at any point rr (this point is input from keyboard)
!!
!! COPYRIGHT
!! Copyright (C) 2000-2007 ABINIT group (GMR,RC,XG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!! grid(nr1,nr2,nr3)=grid matrix
!! nr1=grid size along x
!! nr2=grid size along y
!! nr3=grid size along z
!! rprimd(3,3)=orientation of the unit cell in 3D
!!
!! OUTPUT
!!   only writing
!!
!! PARENTS
!!      cut3d
!!
!! CHILDREN
!!      interpol3d,reduce
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine pointint(grid,nr1,nr2,nr3,rprimd)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_11util
 use interfaces_19cut3d, except_this_one => pointint
#endif
!End of the abilint section

 implicit none

!Arguments--------------------------------------------------------------
!scalars
 integer,intent(in) :: nr1,nr2,nr3
!arrays
 real(dp),intent(in) :: grid(nr1,nr2,nr3),rprimd(3,3)

!Local variables--------------------------------------------------------
!scalars
 integer :: ii,inpopt,jj,mu,okinp
 real(dp) :: denval
!arrays
 real(dp) :: rcart(3),rr(3)

! *************************************************************************

 okinp=0
 do while (okinp==0)
  write(*,*) ' Select the coordinate system:'
  write(*,*) ' Type 1) for cartesian coordinates'
  write(*,*) '  or 2) for crystallographic coordinates'
  read(*,*) inpopt
  if (inpopt==1 .or. inpopt==2) okinp=1
 end do

 if (inpopt==1) then

  write(*,*) ' Input point Cartesian Coord:  X  Y  Z'
  read(*,*) rcart(1),rcart(2),rcart(3)
  call reduce(rr,rcart,rprimd)
  write(*, '(a,3es16.6)' ) ' Crystallographic coordinates: ',rr(1:3)

 else

  write(*,*) ' Input point Crystallographic Coord:  X  Y  Z'
  read(*,*) rr(1),rr(2),rr(3)

  do mu=1,3
   rcart(mu)=rprimd(mu,1)*rr(1)+rprimd(mu,2)*rr(2)+rprimd(mu,3)*rr(3)
  end do

  write(*,*) ' Cartesian coordinates : '
  write(*, '(3es16.6)' ) rcart(1),rcart(2),rcart(3)

 end if

!At this moment the code knows everything needed about the geometric input
!It will further proceed to calculate the interpolation at the demanded point

 rr(1)=mod(mod(rr(1),1._dp)+1._dp,1._dp)
 rr(2)=mod(mod(rr(2),1._dp)+1._dp,1._dp)
 rr(3)=mod(mod(rr(3),1._dp)+1._dp,1._dp)

 write(*, '(a,es16.6)' ) ' X coordinate, r1 is:',rr(1)
 write(*, '(a,es16.6)' ) ' Y coordinate, r2 is:',rr(2)
 write(*, '(a,es16.6)' ) ' Z coordinate, r3 is:',rr(3)

 call interpol3d(rr,nr1,nr2,nr3,denval,grid)
 write(*,*)
 write(*, '(a,es16.6)' ) ' Calculated Value: ',denval

end subroutine pointint
!!***
