       subroutine toabini1(ifpcor,nang,ncores,ncspvs,nbeta,nqf,idim8,
     +            mesh,qtryc,iptype,ikeyee,nbl,nnlz,a,b,exfact,rpcor,
     +            z,zv,r,rab,rc,rcloc,rscore,rsvale,snl,wwnl,title)

c--------------------------------------------------------------------------
c NAME
c toabini1
c
c FUNCTION
c Store various data for later use in uspp2abinit
c
c COPYRIGHT
c Copyright (C) 2005  FJ, MT
c This file is distributed under the terms of the
c GNU General Public License

c==============================================================================

      include "abicom.inc"

c Arguments --------------------------------------------- 
      integer ifpcor,nang,mesh,ncores,ncspvs,nbeta,nqf,qtryc,idim8
      integer iptype(idim3),nbl(idim5),nnlz(idim2),ikeyee(idim3)
      double precision a,b,exfact,rcloc,rpcor,z,zv
      double precision rc(idim5),rscore(idim1),rsvale(idim1),
     +       r(idim1),rab(idim1),snl(idim1,idim2),wwnl(idim2)
      character*20 title

c Commons -----------------------------------------------
      integer stderr
      common /files/ stderr

c Local variables ---------------------------------------
      integer ii,jj,kk
      double precision rpcormax,rpcormin
      double precision pscore(idim1),pscoef(idim8),work(idim1)

c******************************************************************
c BEGIN EXECUTABLE SECTION
c
c Printing out comment
      write(stderr,'(a)') '> USpp->Abinit translator: first call'

c Init various flags
      abierr=0
      abicomment=0
      indbeta=0

c Various scalar data (file header)
      abtitle=title
      abzatm=z
      abzval=zv
      ablmax=nang-1
      abradstp=a
      ablogstp=b

c Test pseudization model
      do ii=1,nbeta
       if (iptype(ii).gt.2) abierr=-1
      enddo
      if (abierr.ne.0) return

c XC functional type
      abexfact=exfact
      if ((exfact.ne. 0.0).and.(exfact.ne.-1.0).and.
     +    (exfact.ne.-2.0).and.(exfact.ne. 5.0)) then
       abierr=-2
       return
      endif

c Spheres radius
      abrcsph=0.d0
      do ii=1,nang
       if(rc(ii).ge.abrcsph) abrcsph=rc(ii)
      enddo

c Mesh sizes
      abmshsph=2+int(log(abrcsph/a+1.d0)/b)
      abmshprj=2+int(log(max(abrcsph,rcloc)/a+1.d0)/b)
      abrcsph=a*(exp(b*(abmshsph-1))-1.d0)
      abmesh2=mesh
      abnval=ncspvs-ncores

c Angular momenta for basis elements (orbitals)
      ii=0
      do jj=1,nang
       do kk=1,nbl(jj)
        ii=ii+1
        aborb(ii)=jj-1
       enddo
      enddo
      if (ii.ne.nbeta) then
       abierr=-3
       return
      endif

c Partial waves basis
      abbassz=nbeta
      do ii=1,abbassz
       abrefkey(ii)=ikeyee(ii)
      enddo

c Core and valence density
      do ii=1,abmesh2
       abcore(ii)=rscore(ii)
       abvale(ii)=rsvale(ii)
      enddo

c Valence states occupancies
      do ii=1,abnval
       abocc(ii)=wwnl(ncores+ii)
      enddo

c Valence states angular momenta
      do ii=1,abnval
       ablval(ii)=(nnlz(ncores+ii)-100*(nnlz(ncores+ii)/100))/10
      enddo

c Atomic eigenfunctions
      do ii=1,abnval
       do jj=1,abmshsph
        absnl(jj,ii)=snl(jj,ncores+ii)
       enddo
      enddo

c Test if ifpcor=1 ; if not, impose it to the max. acceptable value
c Acceptable value= value for which we get: rsvale+pscore>0
c            (this test is not totally exact, but "acceptable")
      if ((ifpcor.eq.0).and.(ncores.gt.0)) then
       abicomment=1
       ifpcor=1
       rpcormin=abrcsph/3.d0
       rpcormax=abrcsph/1.2d0
       rpcor=rpcormax
111    continue
       do ii=1,mesh
        pscore(ii) = rscore(ii)
        work(ii)   = 0.d0
       enddo
       do ii=1,idim8
        pscoef(ii) = 0.d0
       enddo
       call pspcor2(pscore,pscoef,work,rpcor,mesh,r,rab,a,b,3,
     +              nqf,qtryc,idim1,idim8)
       jj=0
       do ii=1,mesh
        if (pscore(ii)+rsvale(ii).lt.0.d0) jj=jj+1
       enddo
       if (jj.gt.0) then
        rpcormax=rpcor
       else
        rpcormin=rpcor
       endif
       if (rpcormax.gt.rpcormin+0.01d0) then
        rpcor=(rpcormin+rpcormax)*0.5d0
        goto 111
       endif
       rpcor=int(100.d0*rpcor)/100.d0-0.01d0
      endif

      return
      end


c=========================================================================
c=========================================================================

      subroutine toabini2(kkbeta,nbeta,phi,psi,beta)

c--------------------------------------------------------------------------
c NAME
c toabini2
c
c FUNCTION
c Store orbitals, psi, phi, beta for later use in uspp2abinit
c
c COPYRIGHT
c Copyright (C) 2005  FJ, MT
c This file is distributed under the terms of the
c GNU General Public License

c=========================================================================

      include "abicom.inc"

c Arguments ---------------------------------------------
      integer nbeta,kkbeta
      double precision beta(idim1,idim3),
     +                 phi(idim1,idim3),psi(idim1,idim3)
 
c Commons -----------------------------------------------
      integer stderr
      common /files/ stderr

c Local variables ---------------------------------------
      integer ib,jb,ii
      integer iwork(idim3)
      double precision binv
      double precision dum1(idim1),bbb(idim3,idim3),
     +                 bbbi(idim3,idim3)

c******************************************************************
c BEGIN EXECUTABLE SECTION
c
      if (abierr.ne.0) return

c Printing out comment
      write(stderr,'(a)') '> USpp->Abinit translator: second call'

c Store partial waves Phi, tPhi, tProj
      do ib=1,nbeta
       do ii=1,kkbeta
        abphi(ii,ib)=psi(ii,ib)
        abtphi(ii,ib)=phi(ii,ib)
        abtproj(ii,ib)=beta(ii,ib)
       enddo
      enddo

      abmesh1=kkbeta

      return
      end


c=========================================================================
c=========================================================================

      subroutine toabini3(nbeta,uuu)

c--------------------------------------------------------------------------
c NAME
c toabini3
c
c FUNCTION
c Store sss=<chi_i|chi_j> for later use in uspp2abinit
c
c COPYRIGHT
c Copyright (C) 2005  FJ, MT
c This file is distributed under the terms of the
c GNU General Public License

c==============================================================================

      include "abicom.inc"

c Arguments --------------------------------------------- 
      integer nbeta
      double precision uuu(idim3,idim3)

c Commons -----------------------------------------------
      integer stderr
      common /files/ stderr

c Local variables ---------------------------------------
      integer ii,jj

c******************************************************************
c BEGIN EXECUTABLE SECTION
c
      if (abierr.ne.0) return

c Printing out comment
      if (indbeta.eq.0)
     +write(stderr,'(a)') '> USpp->Abinit translator: third call'

c Store SSS matrix
      do ii=1,nbeta
       do jj=1,nbeta
        absss(indbeta+ii,indbeta+jj)=uuu(ii,jj)
       enddo
      enddo

      indbeta=indbeta+nbeta
            
      return
      end


c=========================================================================
c=========================================================================

      subroutine toabini4(mesh,rpcor,rspsco,vloc,flname)

c--------------------------------------------------------------------------
c NAME
c toabini4
c
c FUNCTION
c Store seudo core density and Vloc for later use in uspp2abinit
c Call translation routine USpp2Abinit
c
c COPYRIGHT
c Copyright (C) 2005  FJ, MT
c This file is distributed under the terms of the
c GNU General Public License

c==============================================================================

      include "abicom.inc"

c Arguments --------------------------------------------- 
      integer mesh
      double precision rpcor
      double precision rspsco(idim1),vloc(idim1)
      character*40 flname(6)

c Commons -----------------------------------------------
      integer stderr
      common /files/ stderr

c Local variables ---------------------------------------
      integer ii,ilen1,ilen2
      character*132 abflname,abfltmp

c******************************************************************
c BEGIN EXECUTABLE SECTION
c 
      if (abierr.eq.0) then

c Printing out comment
       write(stderr,'(a)') '> USpp->Abinit translator: fourth call'

c Store tcore and Vloc
       do ii=1,mesh
        abtcore(ii)=rspsco(ii)
        abvloc(ii)=vloc(ii)
       enddo

      endif

c Test if an error was encountered
      if (abierr.ne.0) then
       write (stderr,'(/,a)') '> USpp->Abinit translator ERROR:'
       if (abierr.eq.-1) write (stderr,'(a)')
     +    '   - Input variable iptype>2 not compatible !'
       if (abierr.eq.-2) write (stderr,'(a,f5.1,a,/,a)')
     +    '   - Exchange and correlation functional (exfact=',
     +    abexfact,')','     not compatible with Abinit !'
       if (abierr.eq.-3) write (stderr,'(a)')
     +    '   - Incompatible number of basis elements !'
       write (stderr,'(/,a)') '> No file for Abinit was created !'
       return
      endif

c Test if a comment has to be displayed
      if (abicomment.gt.0) then
       write (stderr,'(/,a)') '> USpp->Abinit translator COMMENT:'
       if (abicomment-10*(abicomment/10).ge.1)
     +  write (stderr,'(a,/,a,f5.2,a)')
     +  '  - Variable "ipfcor" was 0 in input file;',
     +  '     The program forced it to 1 and set rpcor=',rpcor,' !',
     +  '     (please verify the consistency of this choice...)'
      endif

c Determine file name for Abinit PAW atomic data
      ilen1=0
      ilen2=0
      do ii=1,len(flname(6))
       if (flname(6)(ii:ii).ne.' ') ilen1=ii
       if ((ii.gt.1).and.(ii.le.len(flname(6))-4)) then
        if (flname(6)(ii:ii+4).eq.'.uspp') ilen2=ii-1
       endif
      enddo
      if (ilen2.gt.0) abflname=flname(6)(1:ilen2)//'.abinit.paw'
      if (ilen2.eq.0) abflname=flname(6)(1:ilen1)//'.abinit.paw'
      if (ilen2.gt.0) abfltmp=flname(6)(1:ilen2)//'.abinit.tmp'
      if (ilen2.eq.0) abfltmp=flname(6)(1:ilen1)//'.abinit.tmp'

c Eventually write intermediate (and temporary) file
c      call wrtoabi(abfltmp)

c Call USPP -> Abinit translator
      write(stderr,'(/,a)') 
     +  '> USpp->Abinit translator: launching translation utility'
      call uspp2abi(abflname)
      
      return
      end


c=========================================================================

      subroutine wrtoabi(abflname)

c--------------------------------------------------------------------------
c NAME
c wrtoabi
c
c FUNCTION
c Write a temporary file used to transfer data between USpp and USpp2Abinit
c
c COPYRIGHT
c Copyright (C) 2005  FJ, MT
c This file is distributed under the terms of the
c GNU General Public License

c==============================================================================

      include "abicom.inc"

c Arguments --------------------------------------------- 
      character*132 abflname

c Commons -----------------------------------------------
      integer stderr
      common /files/ stderr

c Local variables ---------------------------------------
      integer iabinit,ib,ii,in
      parameter(iabinit=44)

c******************************************************************
c BEGIN EXECUTABLE SECTION
c
c     Printing out comment
      write(stderr,'(a)')
     +     ' USpp->Abinit translator: writing temp file:'
      write(stderr,'(a)') '  ',abflname

      open(unit=iabinit,file=abflname,form='formatted')
      write(iabinit,'("TITLE",13x,a)')           abtitle
      write(iabinit,'("ATOMIC_CHARGE",5x,f7.3)') abzatm
      write(iabinit,'("VALENCE_CHARGE",4x,f7.3)')abzval
      write(iabinit,'("XC_TYPE",10x,f5.1)')      abexfact
      write(iabinit,'("BASIS_SIZE",8x,i1)')      abbassz
      write(iabinit,'("ORBITALS",10x,25(1x,i1))')
     +                          (aborb(ib),ib=1,abbassz)
      write(iabinit,'("REF_ENE_KEYS",6x,25(1x,i1))')
     +                       (abrefkey(ib),ib=1,abbassz)
      write(iabinit,'("WAV_MESHSZ",7x,i4)')      abmesh1
      write(iabinit,'("RHO_MESHSZ",7x,i4)')      abmesh2
      write(iabinit,'("SPH_MESHSZ",7x,i4)')      abmshsph
      write(iabinit,'("PRJ_MESHSZ",7x,i4)')      abmshprj
      write(iabinit,'("MESH_STEPS",8x,2(1x,f22.15))')
     +                                  abradstp,ablogstp
      write(iabinit,'("SPH_RADIUS",8x,f22.15)')  abrcsph
      write(iabinit,'("N_VALSTATES",6x,i2)')     abnval
      write(iabinit,'("OCCUPANCIES",7x,25(1x,f8.6))')
     +                          (abocc(ii) ,ii=1,abnval)
      write(iabinit,'("VALSTATE_L",8x,25(1x,i1))')
     +                          (ablval(ii),ii=1,abnval)
      write(iabinit,'("SSS")')
      do ib=1,abbassz
       write(iabinit,'(3x,25(1x,g22.15))')
     +                       (absss(ii,ib),ii=1,abbassz)
      enddo
      do ib=1,abbassz
       write(iabinit,'("PARTIAL_WAVEF",1x,i2)') ib
       write(iabinit,'(3(1x,g22.15))')
     +                       (abphi(ii,ib),ii=1,abmesh1)
      enddo
      do ib=1,abbassz
       write(iabinit,'("AUX_WAVEF",1x,i2)') ib
       write(iabinit,'(3(1x,g22.15))')
     +                      (abtphi(ii,ib),ii=1,abmesh1)
      enddo
      do ib=1,abbassz
       write(iabinit,'("PROJECTOR",1x,i2)') ib
       write(iabinit,'(3(1x,g22.15))')
     +                     (abtproj(ii,ib),ii=1,abmesh1)
      enddo
      write(iabinit,'("CORE_DENSITY")')
      write(iabinit,'(3(1x,g22.15))')
     +                         (abcore(ii),ii=1,abmesh2)
      write(iabinit,'("TCORE_DENSITY")')
      write(iabinit,'(3(1x,g22.15))')
     +                        (abtcore(ii),ii=1,abmesh2)
      write(iabinit,'("VALENCE_DENSITY")')
      write(iabinit,'(3(1x,g22.15))')
     +                         (abvale(ii),ii=1,abmesh2)
      do in=1,abnval
       write(iabinit,'("PARTIAL_VALENCE_DENSITY",1x,i2)') in
       write(iabinit,'(3(1x,g22.15))')
     +                       (absnl(ii,in),ii=1,abmesh1)
      enddo
      write(iabinit,'("VLOC")')
      write(iabinit,'(3(1x,g22.15))')
     +                         (abvloc(ii),ii=1,abmesh2)
      close(iabinit)

      return
      end

