!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_dij0
!! NAME
!! calc_dij0
!! 
!! FUNCTION
!! Compute initial values of Dij = Dij0 (contribution of vh(tnZc))
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the 
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!! 
!! INPUTS
!!  pawarray
!!    %kij(lmn2_size)= Kinetic overlap operator
!!    %q00hat(sph_meshsz)= Qij_hat terms with i,j=(0,0)
!!    %qij0(lmn2_size)= qij_0 terms
!!    %vhnzcij(lmn2_size)= (i,j) channel of the Hartree term inside
!!                         the spheres for the density nZc
!!    %vhtnzcij(lmn2_size)= matrix element of the Hartree potential of
!!                          the ps-density of the nucleus+core electrons
!!  pawdata
!!    %indlmn(6,lmn_size)= Gives l,m,n,ln,lm,s for i=lmn
!!    %rad_(big_meshsz)= rad(:) + AA where rad(i)=AA*(exp[BB*(i-1)]-1)
!!  pawps
!!    %vhtnzc(rho_meshsz)= Hartree potential of the ps-density
!!                         of the nucleus + core electrons
!!  pshead
!!    %log_step= Logarithmic step corresponding to radial mesh
!!    %lmn_size= Number of elements for the paw basis
!!    %sph_meshsz= Dimension of radial mesh for spheres
!!   
!! OUTPUT
!!  pawps
!!    %dij0(lmn2_size)= Part of the Dij term calculated in the psp part
!!
!! PARENTS
!!      uspp2abinit
!!
!! CHILDREN
!!      ctrap
!!
!! SOURCE

 subroutine calc_dij0(pawarray,pawdata,pawps,pshead)

 use defs_basis
 use defs_pawps
 
 implicit none
 
!Arguments ---------------------------------------------
!These types are defined in defs_pawps
 type(pawarray_type) :: pawarray
 type(pawdata_type)  :: pawdata
 type(pawps_type)    :: pawps
 type(pshead_type)   :: pshead

!Local variables ---------------------------------------
 integer :: ilm,ilmn,j0lmn,jlm,jlmn,klmn,iovl,ir
 real(dp) :: intvh
 real(dp),allocatable :: ff(:)
 
! *************************************************************************

 pawps%dij0=zero

!Computation of int[vh(tnzc)*Qijhat(r)dr]
!----------------------------------------
 allocate (ff(pshead%sph_meshsz))
 do ir=1,pshead%sph_meshsz
  ff(ir)=pawps%vhtnzc(ir)*pawarray%q00hat(ir)*pawdata%rad_(ir)
 enddo
 call ctrap(pshead%sph_meshsz,ff,pshead%log_step,intvh)

 do jlmn=1,pshead%lmn_size
  j0lmn=jlmn*(jlmn-1)/2;jlm=pawdata%indlmn(4,jlmn)
  do ilmn=1,jlmn
   klmn=j0lmn+ilmn;ilm=pawdata%indlmn(4,ilmn)
   if (jlm==ilm) pawps%dij0(klmn)=-intvh*pawarray%qij0(klmn)*sqrt(four_pi)
  enddo
 enddo

!Computation of dij0
!-------------------
 pawps%dij0(:)=pawps%dij0(:)+pawarray%kij(:)&
&             +pawarray%vhnzcij(:)-pawarray%vhtnzcij(:)

 end subroutine
!!***
