
/*
 *  Copyright (c) 1998 - 1999, 2001 Karel Zak "Zakkr" <zakkr@zf.jcu.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  $Id: aca.h,v 1.2 2001/01/02 14:16:15 zakkr Exp $
 */

#ifndef __ACA_H
#define __ACA_H

/* ------------------------------------------------------------------------ */

#include <curses.h>

#if !(defined(TRUE) && defined(FALSE))
	#define TRUE	1
	#define FALSE	0
#endif	

#define	RE_ERROR	-1
#define RE_OK		0

#define chN		((char *) 	NULL)
#define inN		((int  *) 	NULL)
#define voN		((void *) 	NULL)

#include <libintl.h>

extern 	char		*_aca_text_domain;

/*
 * If you use complete built-in widgets, mark widget.text_domain as
 * ACA_TD.
 */
#define	ACA_TD		(_aca_text_domain)



   typedef struct {
      int	color,			/* TRUE / FALSE */
      		output_7bit_only, 	/* if TRUE: ACA support only 7bit ascii */
      		input_8bit,		/* if FALSE: ACA set curses meta() */
      
      /* aca timer (all is in milliseconds) */
      		getch_timeout, 		/* select() timeval or curses timeout */
      		fallasleep,		/* elapsed time to go to asleep */
      		fallasleep_incr,	/* fall asleep deepen and deepen 
      					   (this is increment of deep) */
      
      /* after timeout elpse ACA call your func. (if this func. is set) */					   
      		extra_timeout_call; 			/* TRUE / FALSE */
      void	(*extra_timeout_call_fn)(int x);	
      
      /* your func. - ACA call this func. if screen is resized */
      int	extra_resize;				/* TRUE / FALSE */	
      void	(*extra_resize_call_fn)(void *data),
   		*extra_resize_data; 
      
      int	line,			/* TRUE (usage standard line) or FALSE ( '-' '|' '+')  */		
      		keypad,			/* TRUE / FALSE - usage termcap/curses */	
      		spec,			/* TRUE / FALSE - special characters (as a arrow) */
      		forcekey;	
   
   #ifdef HAVE_MOUSE
     int	mouse,			/* TRUE / FALSE	*/	
   		mouse_y,		/* mouse line */
   		mouse_x;		/* mouse col */
     #endif
   	   	
   } ACA;

   extern ACA	aca;

#if DEBUG==1
	#define	_D(x)	fprintf(stderr, "DEBUG: %s\n", x)
#else
	#define	_D(x)
#endif

   extern void print_aca_setting(FILE *f);

/* ------------------------------------------------------------------------ */

/* --- color part --- */

   typedef struct {
      int	color,		/* color number 	*/
	      	fc,		/* foreground color 	*/
	      	bc,		/* background color 	*/
      		bw;		/* black / white	*/
   } aca_COLORS;

   typedef struct {
      int	sel,		/* selected area 			*/
      		nsel,		/* not selected area 			*/
      		sel_astr,	/* selected ACTIVE STRING 		*/
      		nsel_astr,	/* not selected ACTIVE STRING 		*/
      		border_sel,	/* selected border			*/
      		border_nsel,	/* not selected border 			*/
      		title_sel,	/* selected title 			*/
      		title_nsel,	/* not selected title 			*/
      		title_sel_astr, /* selected ACTIVE STRING in title	*/
      		title_nsel_astr,/* not selected ACTIVE STRING in title	*/
		descript;	/* description line(s) color 		*/
   } WidgetColor;

   typedef struct {
   /* dialogs colors */
      int		dlg_bgr,
      			dlg_header,
      			dlg_warning;
      
      /* widgets color */
      WidgetColor	button,		/* color for Wbutton	*/
      			radio,		/* color for Wradio	*/
      			input,		/* color for Winput	*/
      
      	/* color for Wmenu (in any dialogs - see menu flag M_MENUIN) */
      			menu_in,	
      
      	/* color for Wmenu (see menu flag M_MENUOUT) */
      			menu_out,
      
      	/* color for Wmenu (see menu flag M_MENUDIRECT) */
      			menu_direct;
   } TemplateColor;

   extern aca_COLORS 	*GL_c;
   extern TemplateColor	*TplC;

   extern int		aca_init_color(int num);
   extern void		aca_init_pair(int color_num, int fc, int bc, int bw);
   extern TemplateColor *set_TplC( TemplateColor *t);

   inline extern 	void aca_c(int x);

#define aca_uc(x)	attroff ((aca.color ? (*(GL_c+x)).color : (*(GL_c+x)).bw))
#define bold		attron(A_BOLD)
#define ubold		attroff(A_BOLD) 
#define blink		attron(A_BLINK)	  	
#define ublink		attroff(A_BLINK)

#define	ACA_HLINE	(aca.line ? ACS_HLINE 		: '-')  
#define	ACA_VLINE	(aca.line ? ACS_VLINE 		: '|')
#define	ACA_ULCORNER	(aca.line ? ACS_ULCORNER 	: '+')
#define	ACA_URCORNER	(aca.line ? ACS_URCORNER 	: '+')
#define	ACA_LLCORNER	(aca.line ? ACS_LLCORNER 	: '+')
#define	ACA_LRCORNER	(aca.line ? ACS_LRCORNER 	: '+')
#define	ACA_TTEE	(aca.line ? ACS_TTEE 		: '+')
#define	ACA_BTEE	(aca.line ? ACS_BTEE 		: '+')
#define	ACA_LTEE	(aca.line ? ACS_LTEE 		: '+')
#define	ACA_RTEE	(aca.line ? ACS_RTEE 		: '+')
#define	ACA_DARROW	((aca.line && aca.spec) ? ACS_DARROW 	: 'v')
#define	ACA_UARROW	((aca.line && aca.spec) ? ACS_UARROW 	: '^')
#define	ACA_RARROW	((aca.line && aca.spec) ? ACS_RARROW 	: '>')
#define	ACA_LARROW	((aca.line && aca.spec) ? ACS_LARROW	: '<')

   extern void 	mvaddastr(int y, int x, char *astr, int acolor, int color);
   extern void	center_addnstr(int y, int x, char *str, int max);
   extern void	left_addnstr(int y, int x, char *str, int maxlines, int max);	
   extern void	mvaddline_nstr (int y, int x, char *str, int line, int max);	
   extern void	mvaddline_nstr_sht (int y, int x, char *str, int line, int max, int sht);	

   extern void	aca_border(int y, int x, int yn, int xn, int color);
   extern void	draw_linebox(int y, int x, int yn, int xn, int color);
   extern void	clear_linebox(int y, int x, int yn, int xn, int color);
   extern void	clean_box(int y, int x, int yn, int xn, int color);

#define clean_hline(y, x, n, c)	{ aca_c(c); mvhline(y, x, ' ', n); } 

   extern chtype	**init_refresh_buffer();
   extern void	fill_refresh_buffer(chtype **b);
   extern void	print_refresh_buffer(chtype **b);

   extern inline 	void show_run();

   extern int	gethotkey(char *astr);
   extern int	astrlen(char *astr);
   extern char	*astr2str(char *str, char *astr);


/* ------ aca INI part ------ */

#define MAXSIZ_SECTION_NAME	32	/* with '[' and ']' !!! */
#define MAXSIZ_SECTION_CONTENT	BUFSIZ
#define MAXSIZ_SECTION_VALUE	32

   typedef struct INI_SectionData {
      	char		*value,
      			*content;
      		
      		/*  your func. - (if is set) ACA call it for content save,
      		    (you can change content) - your func. must (itself) alloc 
      		    memory for content and set content to data->content */
   	int		(*value_call_fn)(struct INI_SectionData *data, char *value, char *content);
   } INI_SectionData;

   typedef struct INI_Section {
      	char		*name;
      	int		flag;      	
      	INI_SectionData	*data;
      		
      		/* your func. - (if is set) ACA call it before INI_set_data()
      		   for all values in section */
      	int		(*sect_call_fn)(struct INI_Section *sect, char *value, char *content);	
   } INI_Section;

   typedef struct {
   	char		*filename;
   	INI_Section	*section;	
   } aca_INI;
   
/* Section flags: */
#define SECT_SAVE	0x01		/* section need save */ 
#define SECT_SAVED	0x02		/* section is saved  */		
#define SECT_LOAD	0x04   		/* section need load */
#define SECT_LOADED	0x08		/* section is loaded */
#define SECT_DELETE	0x10		/* section is delete */

   
#define TERMINAM_KEYS_SECTION		{ GL_term_name, SECT_LOAD, (INI_SectionData *) NULL, NULL }   
   
   extern INI_Section *INI_sect_flag(aca_INI *ini, char *sname, int flag);	  
  
#define INI_flag_save(ini, sname)   INI_sect_flag(ini, sname, SECT_SAVE)	  
#define INI_flag_delete(ini, sname) INI_sect_flag(ini, sname, SECT_DELETE)	  
#define INI_flag_load(ini, sname)   INI_sect_flag(ini, sname, SECT_LOAD)	  
#define INI_flag_loaded(ini, sname) INI_sect_flag(ini, sname, SECT_LOADED)

   extern INI_Section *INI_set_sect_flag(aca_INI *ini, char *sname, int flag, int set);

#define INI_set_flag_save(ini, sname)   INI_set_sect_flag(ini, sname, SECT_SAVE, TRUE)	  
#define INI_set_flag_delete(ini, sname) INI_set_sect_flag(ini, sname, SECT_DELETE, TRUE)	  
#define INI_set_flag_load(ini, sname)   INI_set_sect_flag(ini, sname, SECT_LOAD, TRUE)	  
#define INI_set_flag_loaded(ini, sname) INI_set_sect_flag(ini, sname, SECT_LOADED, TRUE)

#define INI_unset_flag_save(ini, sname)   INI_set_sect_flag(ini, sname, SECT_SAVE, FALSE)	  
#define INI_unset_flag_delete(ini, sname) INI_set_sect_flag(ini, sname, SECT_DELETE, FALSE)	  
#define INI_unset_flag_load(ini, sname)   INI_set_sect_flag(ini, sname, SECT_LOAD, FALSE)	  
#define INI_unset_flag_loaded(ini, sname) INI_set_sect_flag(ini, sname, SECT_LOADED, FALSE)

   extern int INI_goto_section(FILE *f, char *section);
   extern int INI_load(aca_INI *ini); 
   extern int INI_save(aca_INI *ini); 
   extern int INI_init_data(INI_SectionData *sdata, char *value, char *content);
   extern int INI_set_data(INI_SectionData *sdata, char *value, char *content);
   extern INI_SectionData *INI_load_section(FILE *f, INI_Section *sect); 
   extern void INI_fprintf(FILE *f, aca_INI *ini);
   
   extern int		INI_existData(INI_Section *sect);
   extern INI_Section 	*INI_section (aca_INI *ini, char *sectname);
   extern char 		*INI_value (INI_Section *s, char *valname);
   
   extern char	*separe_str(char *value, int sep);



/* ------------------------------------------------------------------------ */

   typedef struct {
      int	curses;			/* curses standard KEY_ */
      char	*capname,		/* capname of key */
      		*seq,			/* term seqention */	
      		*default_seq;		/* default seqention */	
      int	ctrl,			/* key alternative CTRL+key */
      learn;			/* TRUE / FALSE */			
   } ACA_BASIC_KEYS;

#define MAX_SEQTIME		200000		
#define MAX_BASIC_KEYS		20
 
   extern  ACA_BASIC_KEYS 	basic_keys[];

   extern char	*GL_term_name;
   extern char	GL_seq_buff[256];
   extern int	GL_last_key;
   extern int	GL_current_key;	
   extern int	GL_inlearn_mode;	/* if aca learning key (now!) */

#define	SeqN		((char *) NULL)
#define XCTRL(x)	((x) & 31)
#define T_XCTRL(x)	(x==XCTRL(x) ? TRUE : FALSE)
#define ESC_CHAR	'\033'
#define ESC_STR 	"\033"

/* double ctrl key */
#define D_CTRL_KEY(x, y) \
	((XCTRL(x) == GL_last_key && XCTRL(y) == GL_current_key) ? TRUE : FALSE)	

/* esc key */
#define ESC_KEY(x) \
	(((ESC_CHAR == GL_last_key) && x == GL_current_key) ? TRUE : FALSE)	

/* for menu_seek() (refresh menu, but not go) */ 
#define K_STAY			-100	

/* if screen size is changed get_k() return K_SCREE...	*/
#define K_SCREEN_RESIZED	-110

#define K_MOUSE_L		KEY_MOUSE
#define K_MOUSE_M		-120
#define K_MOUSE_R		-130	
#define K_MOUSE_NOT		-140


extern   void 	aca_keypad(int x);
extern   void	aca_dump_keys(FILE *f, ACA_BASIC_KEYS *k);
extern   int 	learn_keydump_check();
extern   int 	isfunckey( int key ); 
extern   int 	set_learn_key(char *name, char *seq);
extern   void 	init_keys(aca_INI *ini);
extern	 void   init_keys_ini(INI_Section *sect);
extern   int 	timeout_calls(int current);
extern   void 	clean_input ();
extern   int 	find_in_lbuff(char *seq);
extern   int 	check_seq(char *buffer);
extern   int 	get_k();
extern   void 	init_lbuff();
extern   void 	set_lbuff(int key, char *seq);
extern   void 	cpy_lbuff();
extern	 void	cpy_learn2ini(aca_INI *ini);
extern   int 	learn_key(int key);


/* ------------------------------------------------------------------------ */

/* global values */
   extern int	GL_winch_flag,
   		GL_interrupt_flag;

   extern void	end_aca();

   extern void	init_winch();

   extern void	aca_default();
   extern void	init_aca(int def);
   extern void	set_inout_bits (int output_7bit_only, int input_8bit);
   extern void	cur_pre_exec();
   extern void	cur_post_exec();

   extern void	screen_resizer();

   extern FILE	*aca_fileopen(char *filename, char *mode, int errors);

#define READ_LOAD	1
#define MMAP_LOAD	2	

   extern char	*aca_loadfile(int fd, int *flag);
   extern void	aca_unloadfile(char *fbuff, int flag);

   extern int	lines_instr(char *str);
   extern int	linesize_instr(char *str, int *size);
   extern char	*get_line(char *str, int num);
   extern int	line_len(char *str);
   extern int	get_linepoz(char *str, int line, int item);



#define CLEAN_BIT	1
#define	ACA_BITNUM	8

   extern void	set_bit(unsigned int *b, int n, int set);
   extern int	show_bit(int unsigned x, int unsigned i);


/*
 * For text stored in aca.po
 */
#ifndef _aca
	#define	_aca(str)	dgettext(ACA_TD, str)
	#define Naca_(str)	(str)
#endif

#endif /* __ACA_H */
