// -*- C++ -*-

#include "EstablishTrustPolicy.h"

#include "tao/ORB_Constants.h"

ACE_RCSID (Security,
           EstablishTrustPolicy,
           "EstablishTrustPolicy.cpp,v 1.5 2003/10/28 18:34:24 bala Exp")

TAO_EstablishTrustPolicy::TAO_EstablishTrustPolicy (
  const Security::EstablishTrust &trust)
  : trust_ (trust)
{
}

TAO_EstablishTrustPolicy::~TAO_EstablishTrustPolicy (void)
{
}

CORBA::PolicyType
TAO_EstablishTrustPolicy::policy_type (ACE_ENV_SINGLE_ARG_DECL_NOT_USED)
  ACE_THROW_SPEC ((CORBA::SystemException))
{
  return Security::SecEstablishTrustPolicy;
}

CORBA::Policy_ptr
TAO_EstablishTrustPolicy::copy (ACE_ENV_SINGLE_ARG_DECL)
  ACE_THROW_SPEC ((CORBA::SystemException))
{
  TAO_EstablishTrustPolicy *policy = 0;
  ACE_NEW_THROW_EX (policy,
                    TAO_EstablishTrustPolicy (this->trust_),
                    CORBA::NO_MEMORY (
                      CORBA::SystemException::_tao_minor_code (
                        TAO_DEFAULT_MINOR_CODE,
                        ENOMEM),
                      CORBA::COMPLETED_NO));
  ACE_CHECK_RETURN (CORBA::Policy::_nil ());

  return policy;
}

void
TAO_EstablishTrustPolicy::destroy (ACE_ENV_SINGLE_ARG_DECL_NOT_USED)
  ACE_THROW_SPEC ((CORBA::SystemException))
{
}

Security::EstablishTrust
TAO_EstablishTrustPolicy::trust (ACE_ENV_SINGLE_ARG_DECL_NOT_USED)
  ACE_THROW_SPEC ((CORBA::SystemException))
{
  return this->trust_;
}
