// -*- C++ -*-

//=============================================================================
/**
 *  @file   Fault_Detector_T.h
 *
 *  Fault_Detector_T.h,v 1.2 2003/10/15 18:06:29 huangming Exp
 *
 *  @author Huang-Ming Huang <hh1@cse.wustl.edu>
 */
//=============================================================================

#ifndef FAULT_DETECTOR_T_H
#define FAULT_DETECTOR_T_H

#include "Fault_Detector.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

template <class ACCEPTOR, class CONNECTOR, class DETECTION_HANDLER>
class Fault_Detector_T : public Fault_Detector
{
public:
  Fault_Detector_T();
  ~Fault_Detector_T();
  int connect(const FTRT::Location& addr);
protected:
  ACCEPTOR acceptor_;
  CONNECTOR connector_;
private:
  virtual int init_acceptor();
};

#if defined (ACE_TEMPLATES_REQUIRE_SOURCE)
#include "Fault_Detector_T.cpp"
#endif /* ACE_TEMPLATES_REQUIRE_SOURCE */

#if defined (ACE_TEMPLATES_REQUIRE_PRAGMA)
#pragma implementation ("Fault_Detector_T.cpp")
#endif /* ACE_TEMPLATES_REQUIRE_PRAGMA */

#endif
