// Notify_Structured_Push_Consumer.cpp,v 1.3 2005/07/01 20:27:00 michel_j Exp

#include "Notify_Structured_Push_Consumer.h"
#include "Notify_Test_Client.h"

Notify_Structured_Push_Consumer::Notify_Structured_Push_Consumer (
  const char* name,
  unsigned int expected,
  Notify_Test_Client& client)
  : name_ (name),
  expected_ (expected),
  count_ (0),
  client_ (client)
{
  this->client_.consumer_start (this);
}


void
Notify_Structured_Push_Consumer::push_structured_event (
  const CosNotification::StructuredEvent& /*event*/
  ACE_ENV_ARG_DECL_NOT_USED /*ACE_ENV_SINGLE_ARG_PARAMETER*/)
  ACE_THROW_SPEC ((CORBA::SystemException))
{
  ACE_DEBUG((LM_DEBUG, "-"));

  ++count_;

  if (this->count_ > this->expected_)
  {
    ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: too many events received.\n")));
  }
 
  if (this->count_ >= this->expected_)
  {
    this->client_.consumer_done (this);
  }
}

