// This may look like C, but it's really -*- C++ -*-

//=============================================================================
/*
 *  @file Codeset_Manager_Factory_Base.h
 *
 *  Codeset_Manager_Factory_Base.h,v 1.2 2005/07/17 21:50:46 mesnier_p Exp
 *
 *  Interface for the TAO CodeSet Manager.
 *
 *  @author  Mahesh Vedantam <mahesh#ociweb.com>
 */
//=============================================================================

#ifndef TAO_CODESET_MANAGER_FACTORY_BASE_H
#define TAO_CODESET_MANAGER_FACTORY_BASE_H

#include /**/ "ace/pre.h"

#include "ace/Service_Object.h"
#include "ace/Service_Config.h"
#include "TAO_Export.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

class TAO_Codeset_Manager;

/**
 * @class TAO_Codeset_Manager_Factory_Base
 *
 * @brief Base class for creating instances of the codeset manager.
 *
 * @description The base also provides a default implementation which
 * instantiates nothing. This default impl is replaced by the actual
 * implementation is libTAO_Codeset is loaded.
 *
 */

class TAO_Export TAO_Codeset_Manager_Factory_Base : public ACE_Service_Object
{
public:
  virtual ~TAO_Codeset_Manager_Factory_Base ();

  /// Create makes a new instance of the codeset manager for every
  /// call. This allows multiple ORBs to have their own (or none).
  /// This default implementation returns a null pointer only.
  virtual TAO_Codeset_Manager *create(void);

  /// Is_default is called by the ORB Core to determine if it needs
  /// to reload the factory with a dynamically linked libTAO_Codeset.
  /// Statically linked applications get derive implementation by
  /// including "tao/Codeset/Codeset.h" somewhere in their source code.
  virtual int is_default (void) const;

  /// Static initializer ensures the factory is loaded
  static int initialize (void);
};

ACE_STATIC_SVC_DECLARE (TAO_Codeset_Manager_Factory_Base)
ACE_FACTORY_DECLARE (TAO, TAO_Codeset_Manager_Factory_Base)

#include /**/ "ace/post.h"

#endif /* TAO_CODESET_MANAGER_FACTORY_BASE_H */
