// -*- C++ -*-

//=============================================================================
/**
 *  @file     RT_PolicyFactory.h
 *
 *  RT_PolicyFactory.h,v 1.8 2005/06/14 08:47:20 jwillemsen Exp
 *
 *  @author  Angelo Corsaro <corsaro@cs.wustl.edu>
 *  @author  Ossama Othman <ossama@uci.edu>
 */
//=============================================================================


#ifndef TAO_RT_POLICY_FACTORY_H
#define TAO_RT_POLICY_FACTORY_H

#include /**/ "ace/pre.h"

#include "tao/orbconf.h"

#if defined (TAO_HAS_CORBA_MESSAGING) && TAO_HAS_CORBA_MESSAGING != 0

#include "rtcorba_export.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "tao/PI/PI.h"
#include "tao/LocalObject.h"

// This is to remove "inherits via dominance" warnings from MSVC.
// MSVC is being a little too paranoid.
#if defined(_MSC_VER)
#pragma warning(push)
#pragma warning(disable:4250)
#endif /* _MSC_VER */

/// Policy factory for all RTCORBA related policies.
class TAO_RTCORBA_Export TAO_RT_PolicyFactory
  : public PortableInterceptor::PolicyFactory,
    public CORBA::LocalObject
{
public:

  CORBA::Policy_ptr create_policy (CORBA::PolicyType type,
                                   const CORBA::Any &value
                                   ACE_ENV_ARG_DECL_WITH_DEFAULTS)
    ACE_THROW_SPEC ((CORBA::SystemException,
                     CORBA::PolicyError));

  CORBA::Policy_ptr _create_policy (CORBA::PolicyType type
                                    ACE_ENV_ARG_DECL_WITH_DEFAULTS)
    ACE_THROW_SPEC ((CORBA::SystemException,
                     CORBA::PolicyError));
};

#if defined(_MSC_VER)
#pragma warning(pop)
#endif /* _MSC_VER */

#endif /* TAO_HAS_CORBA_MESSAGING && TAO_HAS_CORBA_MESSAGING != 0 */

#include /**/ "ace/post.h"

#endif /* TAO_RT_POLICY_FACTORY_H */
