//
// Sender_i.h,v 1.4 2005/07/04 08:48:58 jwillemsen Exp
//

#ifndef MT_BIDIR_RECEIVER_H
#define MT_BIDIR_RECEIVER_H
#include /**/ "ace/pre.h"

#include "SenderS.h"

class ACE_Manual_Event;

/**
 * Simply print count how many bytes were received.
 */
class Sender_i
  : public virtual POA_Sender
{
public:
  /// Constructor
  Sender_i (int no_clients,
            ACE_Manual_Event &event);

  // = The skeleton methods
  virtual CORBA::Long receiver_object (Receiver *recv
                                       ACE_ENV_ARG_DECL)
    ACE_THROW_SPEC ((CORBA::SystemException,
                     Sender::Table_Full));

  /// Public method defined locally
  void send_message (ACE_ENV_SINGLE_ARG_DECL);

private:
  /// Synchronizing acces to this class
  TAO_SYNCH_MUTEX mutex_;

  /// An event for waking other threads
  ACE_Manual_Event &event_;

  /// An array of receiver pointers
  Receiver **receivers_;

  /// Size of the <this->receivers_> array
  int no_clients_;

  /// Receiver index
  int last_index_;

  /// Payload that is being sent
  Receiver::Payload payload_;
};

#include /**/ "ace/post.h"
#endif /* MUXING_RECEIVER_H */
