/* -*- C++ -*- */
// UPIPE_Connector.inl,v 4.1 2004/06/16 07:57:23 jwillemsen Exp

// Creates a Local ACE_UPIPE.
ACE_INLINE
ACE_UPIPE_Connector::ACE_UPIPE_Connector (ACE_UPIPE_Stream &new_stream,
                                          const ACE_UPIPE_Addr &addr,
                                          ACE_Time_Value *timeout,
                                          const ACE_Addr &local_sap,
                                          int reuse_addr,
                                          int flags,
                                          int perms)
{
  ACE_TRACE ("ACE_UPIPE_Connector::ACE_UPIPE_Connector");
  if (this->connect (new_stream, addr, timeout, local_sap,
		     reuse_addr, flags, perms) == -1
      && timeout != 0 && !(errno == EWOULDBLOCK || errno == ETIME))
    ACE_ERROR ((LM_ERROR,
                ACE_LIB_TEXT ("address %s, %p\n"),
                addr.get_path_name (),
                ACE_LIB_TEXT ("ACE_UPIPE_Connector")));
}

ACE_INLINE int
ACE_UPIPE_Connector::reset_new_handle (ACE_HANDLE handle)
{
  ACE_UNUSED_ARG (handle);
  // Nothing to do here since the handle is not a socket
  return 0;
}
