/*
 * This file is part of ACGVision, SaaS system-monitoring software
 * Copyright (C) 2009 ACGCenter
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.acgvision.agent.run;

import com.acgvision.core.ws.Period;
import com.acgvision.core.ws.UpdateJobs;
import org.apache.log4j.Logger;


/**
 *
 * @author Rémi Debay <remi.debay@acgcenter.com>
 */
public class Manager extends Thread {
protected static final Logger logger = Logger.getLogger(Manager.class);
private static UniqueList<Task> queue=null;
private boolean run = true;

    private void runUpdate() {
        logger.warn("Updating Job List");
       queue = com.acgvision.agent.run.Main.sender.update(Main.host);
    }

    public Manager(){
       this.runUpdate();
    }
    
    /**
     * Sleeps until next job and then wait until next available processor.
     * @param t
     */
    private void waitUntilNext(Task t) {
        //int WAITINGTIME = 1000;
        try {
            Long d = t.getTimeToNext();
            if (logger.isDebugEnabled()) {
                logger.debug("Endormissement du thread pour :" + d + " millisecondes");
            }
            if (d < 0) {
                logger.debug("On a dépassé la date d'éxécution, on dort 100ms.");
                sleep(100);
            } else {
                sleep(d);//fais dodo
            }
        } catch (InterruptedException ex) {
            logger.warn("Error while waiting for next job", ex);
        }
    }

    @Override
    public void run() {
        while (run) {
            if (!queue.isEmpty()) {
                Task task = (Task) queue.getFirst();//on regarde la prochaine tache à éxécuter
               if(logger.isInfoEnabled()) logger.info("La prochaine tache est :"+task.getJob().getName() + " à "+ task.getNextTime().toString());
                waitUntilNext(task); //on dors en attendant le prochain boulot

               if(logger.isInfoEnabled()) logger.info("Démarrage d'un nouveau thread.");
                //on vérifie si l'arret a été demandé.
                if(run){
                    //on vérifie si c'est un mise à jour
                    if (task.getJob() instanceof UpdateJobs){
                     // if(logger.isInfoEnabled())  logger.info("Mise à jour des jobs.");
                        runUpdate()   ;
                    }else{
                       if(logger.isInfoEnabled()) logger.info("Démarrage des controles.");
                        new Worker(task).start();//on éxécute la tache en arrière plan
                        logger.debug("Suppression de la tache courante");
                        queue.remove(task); //on remet la tache à sa place
                        //Passage du GC
                        //System.gc();
                        task.generateWhen();
                        logger.debug("Réinsertion de la tache");
                        queue.addUnique(task);
                    }
                }
            } else {
                //si la liste est vide on demande dune mise à jour automatique dans 24h
               if(logger.isInfoEnabled()) logger.info("Plannification d'une mise à jour");
                
             generateUpdateTask();
            }
        }
    }

    /**
     * Generates an update task in the next X Minutes
     */
    private void generateUpdateTask() {
        int MINUTES = 10;
        UpdateJobs updateJob = new UpdateJobs();
        Task t = new Task();
        Period p = new Period();
        p.setYear(-1);
        p.setMonth(-1);
        p.setDay(-1);
        p.setHour(-1);
        p.setMinute(MINUTES);
        updateJob.setSchedule(p);
        t.setJob(updateJob);
        t.generateWhen();
        Manager.queue.add(t);
    }

    /**
     * @param run the run to set
     */
    public void setRun(boolean run) {
        this.run = run;
    }
}
