<?php
/*  
 * Analysis Console for Intrusion Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000, 2001 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose: Displays the actual .GIF/.PNG/.TIFF image
 *          of the chart
 *
 * Input GET/POST variables
 *   - width: chart width
 *   - height: chart width
 *   - title: chart title
 *   - xaxis_label: x-axis label
 *   - yaxis_label: y-axis label
 *   - xdata[][]: data and label array for the y-axis
 *   - yaxis_scale: (boolean) 0: linear; 1: logarithmic
 *   - rotate_xaxis_lbl: (boolean) rotate X-axis labels 90 degrees
 *   - style: [bar|line] chooses the style of the chart
 */

  include ("acid_conf.php");
  include ("acid_graph_common.php");

  session_start();
  session_register('xdata');

  LoadGraphingLib($ChartLib_path);

  /* Verifies that the chart width is not too small
   *
   * algorithm: width >= const + number_of_points * factor
   */
  $width_const  = 50;
  $width_factor = 10;
  
  if ( $width < ($width_const + count ($data) * $width_factor)) {
    $width = $width_const + count ($data) * $width_factor;
  }

  $graph = new PHPlot($width, $height);
  $graph->SetIsInline("0");
  $graph->SetBrowserCache("0");

  /* Allocate enough space for the X,Y-axis data label */
  $x_maxlength = 10;     /* 10 is the PHP default size */  

  /* Create the data array */
  for ($i = 0; $i < count($xdata); $i++)
  {
      if ( $style != "pie" )
      {
         $xdata_graph[$i] = array($xdata[$i][0], $xdata[$i][1]);
      }
      else
      {
         $xdata[$i] = array( count($data)+1 );
         $xdata[$i][0] = $datalbl[$i];
         for ( $j = 1; $j < $i; $j++)
            $xdata[$i][$j] = 0;
         $xdata[$i][$i+1] = $data[$i];

         $legend[$i] = $datalbl[$i];
      }

      if (strlen($xdata[$i][0]) > $x_maxlength)
      {
        // if the label is too small, expand the label size to fit
	$x_maxlength = strlen($xdata[$i][0]);
      }
  }

  $graph->SetDataType("text-data");
  $graph->SetPlotType($style);
  
  switch($style)
  {
     case "bars":
        $graph->SetDataType("text-data");
        break;
     case "linepoints":
        $graph->SetDataType("text-data");
        break;
     case "pie":
        $graph->SetDataType("text-data");
        $graph->SetLegend($legend);
        break;
     case "thinbarline":
        $graph->SetDataType("data-data");
        break;
  }

  /* read the X-axis labels as text */
  $graph->SetXGridLabelType ("title");

  $graph->SetPrecisionY(0);
  $graph->SetPrecisionX(0);

  $graph->SetBackgroundColor($chart_bg_color_default);
  $graph->SetLightGridColor($chart_lgrid_color_default);

  /* Check if need to rotate X-Axis label */
  if ( $rotate_xaxis_lbl == 1 )
     $graph->SetXDataLabelAngle(90);

  $graph->SetFileFormat($chart_file_format);
  //$graph->SetUseTTF("0");

  /* Set y-axis scale */
  if ( $yaxis_scale == 1 )
    $graph->SetYScaleType("log");

  $graph->SetXDataLabelMaxlength($x_maxlength);
  $graph->SetDrawYGrid("1");
  $graph->SetDataValues($xdata_graph);
  $graph->SetXLabel($xaxis_label);
  $graph->SetYLabel($yaxis_label);
  $graph->SetTitle($title);
  $graph->SetDataColors( array( $chart_bar_color_default ),
                         array("black") );
  //$graph->SetBackgroundColor("grey");
  $graph->DrawGraph();
  //$graph->DrawLegend(100, 100, '');
?>