(in-package "ACL2")

(program)

(defun same-except-doc-strings1 (x y)
  (cond
   ((or (atom x) (atom y))
    (and (null x) (null y)))
   ((and (doc-stringp (car x))
         (doc-stringp (car y)))
    (same-except-doc-strings1 (cdr x) (cdr y)))
   (t (and (equal (car x) (car y))
           (same-except-doc-strings1 (cdr x) (cdr y))))))

(defun same-except-doc-strings1-lst (x y)
  (cond ((or (endp x) (endp y))
         (and (null x) (null y)))
        (t (and (same-except-doc-strings1 (car x) (car y))
                (same-except-doc-strings1-lst (cdr x) (cdr y))))))

(defun same-except-doc-strings2 (x y)
  (cond
   ((or (atom x) (atom y))
    (equal x y))
   ((or (and (eq (car x) 'progn)
             (eq (car y) 'progn))
        (and (eq (car x) 'encapsulate)
             (eq (car y) 'encapsulate))
        (and (eq (car x) 'mutual-recursion)
             (eq (car y) 'mutual-recursion)))
    (same-except-doc-strings1-lst (cdr x) (cdr y)))
   (t (same-except-doc-strings1 x y))))

(defun diff-except-doc-strings (n lst1 lst2)
  (cond
   ((or (endp lst1) (endp lst2))
    (if (and (null lst1) (null lst2))
        nil
      (list n (car lst1) (car lst2))))
   (t (if (same-except-doc-strings2 (car lst1) (car lst2))
          (diff-except-doc-strings (1+ n) (cdr lst1) (cdr lst2))
        (list n (car lst1) (car lst2))))))

(defun compare-files (file1 file2 state)
  (pprogn
   (fms "Comparing ~s0 and ~s1.~%"
        (list (cons #\0 file1)
              (cons #\1 file2))
        *standard-co*
        state
        nil)
   (er-let*
    ((lst1 (read-file file1 state))
     (lst2 (read-file file2 state)))
    (value (diff-except-doc-strings 1 lst1 lst2)))))

(defun compare-acl2-files1 (files dir1 dir2 state)
  ;; Returns t or else causes an appropriate error.
  (cond
   ((endp files)
    (value t))
   (t (er-let*
       ((val (compare-files
              (concatenate 'string dir1 (car files) ".lisp")
              (concatenate 'string dir2 (car files) ".lisp")
              state)))
       (cond
        ((null val)
         (compare-acl2-files1 (cdr files) dir1 dir2 state))
        (t
         (er soft 'compare-acl2-files
             "The versions of file ~p0 differ in their ~n1 positions.  Compare ~
              the form~|~p2~|in directory ~p3 with the form ~|~p4~| in ~
              directory ~p5."
             (car files) (list (car val)) (cadr val) dir1 (caddr val) dir2)))))))

(defmacro compare-acl2-files (dir1 dir2)
  ;; Call this after executing (LP!).
  `(compare-acl2-files1
    (delete1-equal "interface-raw" *acl2-files*)
    ,dir1 ,dir2 state))
