(in-package "ACL2")
;(include-book "include-book-macros")

(local (include-book "expt"))
(local (include-book "expt2"))
(local (include-book "arith2"))
(local (include-book "fp"))
(local (in-theory (disable a15)))

(defun cat (x y n)
  (+ (* (expt 2 (nfix n)) (nfix x)) (nfix y)))

;(:type-prescription cat) should say that mulcat always returns a natural

(in-theory (disable cat))

(defthm cat-nonnegative-integer-type
  (and (integerp (CAT X Y N))
       (<= 0 (CAT X Y N)))
  :rule-classes (:type-prescription)
  )

;this rule is no better than cat-nonnegative-integer-type and might be worse
(in-theory (disable (:type-prescription cat)))

;just a rewrite rule
(defthm cat-natp
  (natp (cat x y n)))

;became less general when we made cat nfix its args
(defthm cat-0
    (implies (and (case-split (<= 0 y))
                  (case-split (integerp y)))		  
	     (equal (cat 0 y n) y))
    :hints (("Goal" :in-theory (enable cat))))

;became less general when we made cat nfix its args
(defthm cat-x-0-0
  (implies (and (case-split (<= 0 x))
                (case-split (integerp x)))
           (equal (cat x 0 0)
                  x))
  :hints (("Goal" :in-theory (enable cat)))
)

;also have integerp-cat

;dup in irepsproofs.lisp
;a hyp was causing problems (in one case, it was false, and ACL2 refused to rewrite a literal involving cat,
;since in doing so it generated a false assumption due to the case split in hyp 1 of this rule (the problem is
;that the literal wasn't rewritten at all!)


#|
;old form:
(defthm cat-upper-bound
  (implies (and (integerp x)
                (bvecp y n) ;expensive?
                (integerp n))
           (< (cat x y n)
              (+ (* (expt 2 n) x) (expt 2 n))))
  :hints (("Goal" :in-theory (enable cat bvecp)))
  :rule-classes (:rewrite (:linear :trigger-terms ((cat x y n))))
  )

|#

;this can be really expensive
;old form:
(defthm cat-upper-bound
  (implies (and (< y (expt 2 n))
                (<= 0 x)
                (integerp x)
                (<= 0 y)
                (integerp n)
                (<= 0 n)
                )
           (< (cat x y n)
              (+ (* (expt 2 n) x) (expt 2 n))))
  :hints (("Goal" :in-theory (enable cat )))
  :rule-classes (:rewrite (:linear :trigger-terms ((cat x y n))))
  )



;dup
(defun bvecp (x k)
  (and (integerp x)
       (>= x 0)
       (< x (expt 2 k))))
(in-theory (disable bvecp))


(encapsulate
 ()
 (local (DEFTHM cat-bvecp-rewrite-fw
          (IMPLIES (AND (INTEGERP N)
                        (<= 0 N)
                        (INTEGERP P)
                        (<= 0 P)
                        (integerp x)
                        (<= 0 x)
                        (>= P N) ;drop?
                        (force (BVECP Y N))
                        )
                   (implies (BVECP (CAT X Y N) P)
                            (BVECP X (- P N))))
          :rule-classes nil
          :hints (("Goal" :in-theory (enable bvecp expt-split cat)))
          ))

 (local (defthm hack-hack
          (implies (and (integerp x)
                        (integerp y)
                        (integerp m)
                        (<= 0 m)
                        (integerp n)
                        (<= 0 n)
                        (< x (expt 2 m))
                        (< y (expt 2 n))
                        )
                   (< (+ (/ y (expt 2 n)) x)
                      (expt 2 m)))
          :hints (("Goal" :in-theory (set-difference-theories
                                      (enable expt-split)
                                      '(a15))))))

 (local (defthm hack-cat
          (implies (and (integerp x)
                        (integerp y)
                        (integerp m)
                        (<= 0 m)
                        (integerp n)
                        (<= 0 n)

                        (< x (expt 2 m))
                        (< y (expt 2 n))
                        )
                   (< (+ y (* x (expt 2 n)))
                      (expt 2 (+ m n))))
          :hints (("Goal" :in-theory (set-difference-theories
                                      (enable expt-split)
                                      '(a15 hack-hack))
                   :use (hack-hack
                         (:instance  mult-both-sides-of-<-by-positive (a (+ X (* Y (/ (EXPT 2 N)))))
                                     (b (EXPT 2 M))
                                     (c (expt 2 n))))))))

 (local (in-theory (enable bvecp)))
           
 (local (DEFTHM cat-bvecp-rewrite-bk
          (IMPLIES (AND (INTEGERP N)
                        (<= 0 N)
                        (INTEGERP P)
                        (<= 0 P)
                        (integerp x)
                        (<= 0 x)
                        (>= P N) ;drop?
                        (force (BVECP Y N))
                        )
                   (implies
                    (BVECP X (- P N))
                    (BVECP (CAT X Y N) P)))
          :rule-classes nil
          :hints (("Goal" :in-theory (set-difference-theories
                                      (enable cat)
                                      '(hack-cat))
                   :use (:instance hack-cat (n n) (m (- p n)))))))

 (defthm cat-bvecp-rewrite
   (implies (and (>= p n) ;handle the other case?
                 (case-split (integerp x))
                 (case-split (<= 0 x))
                 (case-split (bvecp y n))
                 (case-split (natp n))
                 (case-split (natp p))
                 )
            (equal (bvecp (cat x y n) p)
                   (bvecp x (- p n))))
   :hints (("Goal" 
            :use (cat-bvecp-rewrite-fw cat-bvecp-rewrite-bk))
           ))

 (local (defthm hack-4
          (implies (and (integerp x)
                        (<= 0 x)
                        (not (equal x 0)))
                   (>= x 1))))

;expensive? handle this better somehow?
 (local (defthm hack-3
          (implies (and (integerp x)
                        (<= 0 x)
                        (not (equal x 0))
                        (rationalp a)
                        (<= 0 a)
                        )
                   (>= (* x a) a))
          :rule-classes :linear
          :hints (("Goal" :in-theory (disable
                                      hack-4
                                      CANCEL-IN-PRODS-<
                                      CANCEL-TIMES-<-ERIC-1)
                   :use (hack-4
                         (:instance mult-both-sides-of-<-by-positive
                                    (b a) (a (* A X)) (c (/ a))))))))


;better names?
 (DEFTHM cat-bvecp-other-case
   (IMPLIES (AND (< P N)
                 (INTEGERP N)
                 (<= 0 N)
                 (INTEGERP P)
                 (<= 0 P)
                 (integerp x)
                 (<= 0 x)
                 (integerp y)
                 (<= 0 y)
                 )
            (equal (BVECP (CAT X Y N) P)
                   (and (BVECP y p)
                        (equal 0 x)))
            )
   :hints (("Goal" :in-theory (set-difference-theories
                               (enable power2p cat)
                               '( ;EXPT-strong-MONOTONE-linear-eric
;EXPT-MONOTONE-linear-eric
                                 expt-compare))
            :use (:instance EXPT-compare (lhs (expt 2 p)) (rhs (expt 2 n)))))
   :otf-flg t
   )
 )









;from sse-div proofs:

;(include-book "highbits")
;(include-book "lowbits")

#|
;make more general
;also make ncat ver
(defthm highbits-cat
  (implies (and (integerp x)
                (<= 0 x)
                (force (bvecp y n))
                (integerp n)
                (<= 0 n)
                )
           (equal (highbits (CAT x y n) n)
                  x))
  :hints (("Goal" :in-theory (enable expt-split
                                     cat 
                                     highbits))))
|#

(local (defthm hack-10
    (implies (and (integerp x)
		  (integerp y)
		  (< x y))
	     (<= x (1- y)))
  :rule-classes ()))

(local (defthm cat-bvecp-simple
    (implies (and (natp n)
		  (natp p)
		  (bvecp x m)
		  (natp m)
		  (bvecp y n)
		  (>= p (+ m n)))
	     (bvecp (cat x y n) p))
  :rule-classes ()
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable natp bvecp cat)
                              '(expt-compare EXPT-COMPARE-EQUAL))
		  :use (expo+
			(:instance hack-10 (y (expt 2 m)))
			(:instance expt-monotone (m p))
;			(:instance integerp-expt-type (n m))
			(:instance expt-monotone (m p) (n (+ m n))))))))

(defthm cat-bvecp
    (implies (and (>= p n) ;handle other case?
                  (bvecp x (- p n))
                  (case-split (natp n))
		  (case-split (natp p))
		  (case-split (bvecp y n))
                  )
	     (bvecp (cat x y n) p))
  :hints (("Goal" :in-theory (enable natp bvecp)
		  :use ((:instance cat-bvecp-simple (m (- p n)))))))

(defthm cat-0-rewrite
    (implies (and (case-split (integerp x))
		  (case-split (<= 0 x)))
	     (equal (cat 0 x n) x))
    :hints (("Goal" :in-theory (enable cat))))

(defthm cat-with-x-not-a-natural
  (implies (or (not (integerp x))
               (< x 0))
           (equal (cat x y n)
                  (nfix y)))
  :hints (("Goal" :in-theory (enable cat))))

(defthm cat-with-y-not-a-natural
  (implies (or (not (integerp y))
               (< y 0))
           (equal (cat x y n)
                  (* (nfix x) (expt 2 (nfix n)))))
  :hints (("Goal" :in-theory (enable cat))))

(defthm cat-with-n-not-a-natural
  (implies (or (not (integerp n))
               (< n 0))
           (equal (cat x y n)
                  (+ (nfix x) (nfix y))))
  :hints (("Goal" :in-theory (enable cat))))



;might be able to generalize this more
(defthm cat-upper-bound-2
  (implies (and (< x (expt 2 k)) ; k is a free var
                (case-split (< y (expt 2 n)))
                (case-split (integerp k))
                (case-split (<= 0 k))
                (case-split (integerp n))
                (case-split (<= 0 n))
                )
           (< (cat x y n)
              (expt 2 (+ n k))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable bvecp expt-split)
                              '(CAT-BVECP-REWRITE CAT-BVECP ))
           :use ((:instance <-TRANSITIVE (a y) (b (expt 2 n)) (c (* (EXPT 2 K) (EXPT 2 N))))
                 (:instance cat-bvecp (p (+ n k)))))))

(defthm cat-assoc
  (implies (and (case-split (<= 0 m)) ;new now that cat fixes its args
                (case-split (<= 0 n)) ;new now that cat fixes its args
                (case-split (integerp m))
                (case-split (integerp n))
                )
           (equal (cat (cat x y m) z n)
                  (cat x (cat y z n) (+ m n))))
  :hints (("Goal" :in-theory (enable cat))))


#|
(defthm cat-equal-rewrite
  (implies (and (natp x1)
                (natp y1)
                (natp x2)
                (natp y2)
                (bvecp y1 n)
                (bvecp y2 n)
                (natp n))
           (equal (equal (cat x1 y1 n)
                         (cat x2 y2 n))
                  (and (equal x1 x2)
                       (equal y1 y2))))
  :hints (("Goal" :in-theory (enable cat)))
)
                
|#         
                
                
                