(in-package "ACL2")

(local (include-book "predicate"))
(local (include-book "fp2"))
(local (include-book "frac-coeff"))


(defthm unary-divide-less-than-zero
  (implies (case-split (rationalp x)) ;drop?
           (equal (< (/ x) 0)
                  (< x 0))))

(defthm unary-divide-greater-than-zero
  (implies (case-split (rationalp x))
           (equal (< 0 (/ x))
                  (< 0 x))))

(defthm unary-divide-equal-0
  (implies (case-split (acl2-numberp x))
           (equal (equal 0 (/ x))
                  (equal 0 x))))

(defthm unary-divide-equal-non-zero-constant
  (implies (and (syntaxp (and (quotep k) (not (equal 0 (cadr k)))))  ;drop?
                (case-split (not (equal 0 k)))
                (case-split (acl2-numberp x))
                (case-split (acl2-numberp k))
                )
           (equal (equal k (/ x))
                  (equal (/ k) x))))

;make a negative case?
(defthm unary-divide-less-than-non-zero-constant
  (implies (and (syntaxp (and (quotep k) (not (equal 0 (cadr k)))))  ;drop?
                (<= 0 k)
                (case-split (<= 0 x))
                (case-split (not (equal 0 k)))
                (case-split (not (equal 0 x)))
                (case-split (rationalp x))
                (case-split (rationalp k))
                )
           (equal (< (/ x) k)
                  (< (/ k) x))))


;once with this msg failed:
;1x (:REWRITE UNARY-DIVIDE-GREATER-THAN-NON-ZERO-CONSTANT) failed because it permutes a big term forward.
;so I changed the conclusion to not use unary-/
(defthm unary-divide-greater-than-non-zero-constant
  (implies (and (syntaxp (and (quotep k) (not (equal 0 (cadr k)))))  ;drop?
                (<= 0 k)
                (case-split (<= 0 x))
                (case-split (not (equal 0 k)))
                (case-split (not (equal 0 x)))
                (case-split (rationalp x))
                (case-split (rationalp k))
                )
           (equal (< k (/ x))
                  (< x (/ 1 k)))))